/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.saves;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.SettingsAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ungp.api.saves.UNGP_DataSaverAPI;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.utils.Constants;

public class UNGP_BlueprintsDataSaver
implements UNGP_DataSaverAPI {
    public List<String> fighters = new ArrayList<String>();
    public List<String> ships = new ArrayList<String>();
    public List<String> weapons = new ArrayList<String>();
    public List<String> hullmods = new ArrayList<String>();
    public int bpAmount = 0;

    @Override
    public UNGP_DataSaverAPI createSaverBasedOnCurrentGame(UNGP_InGameData inGameData) {
        UNGP_BlueprintsDataSaver dataSaver = new UNGP_BlueprintsDataSaver();
        FactionAPI playerFaction = Global.getSector().getPlayerFaction();
        dataSaver.ships = new ArrayList<String>(playerFaction.getKnownShips());
        dataSaver.fighters = new ArrayList<String>(playerFaction.getKnownFighters());
        dataSaver.weapons = new ArrayList<String>(playerFaction.getKnownWeapons());
        dataSaver.hullmods = new ArrayList<String>(playerFaction.getKnownHullMods());
        dataSaver.updateBlueprintAmount();
        return dataSaver;
    }

    public void updateBlueprintAmount() {
        this.bpAmount = this.ships.size() + this.fighters.size() + this.weapons.size() + this.hullmods.size();
    }

    public int add(UNGP_BlueprintsDataSaver other) {
        int lastBpAmount = this.bpAmount;
        this.fighters.removeAll(other.fighters);
        this.fighters.addAll(other.fighters);
        this.ships.removeAll(other.ships);
        this.ships.addAll(other.ships);
        this.weapons.removeAll(other.weapons);
        this.weapons.addAll(other.weapons);
        this.hullmods.removeAll(other.hullmods);
        this.hullmods.addAll(other.hullmods);
        this.updateBlueprintAmount();
        return this.bpAmount - lastBpAmount;
    }

    @Override
    public UNGP_DataSaverAPI createEmptySaver() {
        return new UNGP_BlueprintsDataSaver();
    }

    @Override
    public void loadDataFromSavepointSlot(JSONObject jsonObject) throws JSONException {
        int i;
        this.ships.clear();
        this.fighters.clear();
        this.weapons.clear();
        this.hullmods.clear();
        JSONArray array = jsonObject.optJSONArray("ships");
        if (array != null) {
            for (i = 0; i < array.length(); ++i) {
                this.ships.add(array.getString(i));
            }
        }
        if ((array = jsonObject.optJSONArray("fighters")) != null) {
            for (i = 0; i < array.length(); ++i) {
                this.fighters.add(array.getString(i));
            }
        }
        if ((array = jsonObject.optJSONArray("weapons")) != null) {
            for (i = 0; i < array.length(); ++i) {
                this.weapons.add(array.getString(i));
            }
        }
        if ((array = jsonObject.optJSONArray("hullmods")) != null) {
            for (i = 0; i < array.length(); ++i) {
                this.hullmods.add(array.getString(i));
            }
        }
        this.updateBlueprintAmount();
    }

    @Override
    public void saveDataToSavepointSlot(JSONObject jsonObject) throws JSONException {
        jsonObject.put("ships", this.ships);
        jsonObject.put("fighters", this.fighters);
        jsonObject.put("weapons", this.weapons);
        jsonObject.put("hullmods", this.hullmods);
    }

    @Override
    public void startInheritDataFromSaver(TooltipMakerAPI root, Map<String, Object> params) {
        String bpId;
        FactionAPI player = Global.getSector().getPlayerFaction();
        float inheritBPFactor = ((Float)params.get("inheritBPFactor")).floatValue();
        int shipAmount = (int)(inheritBPFactor * (float)this.ships.size());
        int fighterAmount = (int)(inheritBPFactor * (float)this.fighters.size());
        int weaponAmount = (int)(inheritBPFactor * (float)this.weapons.size());
        int hullmodAmount = (int)(inheritBPFactor * (float)this.hullmods.size());
        ArrayList<String> curShipBps = new ArrayList<String>();
        ArrayList<String> curFighterBps = new ArrayList<String>();
        ArrayList<String> curWeaponBps = new ArrayList<String>();
        ArrayList<String> curHullmodBps = new ArrayList<String>();
        SettingsAPI setting = Global.getSettings();
        for (ShipHullSpecAPI spec : setting.getAllShipHullSpecs()) {
            curShipBps.add(spec.getHullId());
        }
        for (ShipHullSpecAPI spec : setting.getAllFighterWingSpecs()) {
            curFighterBps.add(spec.getId());
        }
        for (ShipHullSpecAPI spec : setting.getAllWeaponSpecs()) {
            curWeaponBps.add(spec.getWeaponId());
        }
        for (ShipHullSpecAPI spec : setting.getAllHullModSpecs()) {
            curHullmodBps.add(spec.getId());
        }
        int inheritedShip = 0;
        int inheritedFighter = 0;
        int inheritedWeapon = 0;
        int inheritedHullmod = 0;
        WeightedRandomPicker picker = new WeightedRandomPicker();
        for (String bp : this.ships) {
            if (!curShipBps.contains(bp) || player.knowsShip(bp)) continue;
            picker.add((Object)bp);
        }
        for (int i = 0; i < shipAmount && !picker.isEmpty(); ++i) {
            bpId = (String)picker.pickAndRemove();
            player.addKnownShip(bpId, true);
            ++inheritedShip;
        }
        picker = new WeightedRandomPicker();
        for (String bp : this.fighters) {
            if (!curFighterBps.contains(bp) || player.knowsFighter(bp)) continue;
            picker.add((Object)bp);
        }
        for (int i = 0; i < fighterAmount && !picker.isEmpty(); ++i) {
            bpId = (String)picker.pickAndRemove();
            player.addKnownFighter(bpId, true);
            ++inheritedFighter;
        }
        picker = new WeightedRandomPicker();
        for (String bp : this.weapons) {
            if (!curWeaponBps.contains(bp) || player.knowsWeapon(bp)) continue;
            picker.add((Object)bp);
        }
        for (int i = 0; i < weaponAmount && !picker.isEmpty(); ++i) {
            bpId = (String)picker.pickAndRemove();
            player.addKnownWeapon(bpId, true);
            ++inheritedWeapon;
        }
        picker = new WeightedRandomPicker();
        for (String bp : this.hullmods) {
            if (!curHullmodBps.contains(bp) || player.knowsHullMod(bp)) continue;
            picker.add((Object)bp);
        }
        for (int i = 0; i < hullmodAmount && !picker.isEmpty(); ++i) {
            bpId = (String)picker.pickAndRemove();
            player.addKnownHullMod(bpId);
            ++inheritedHullmod;
        }
        root.setParaSmallInsignia();
        root.addPara(Constants.root_i18n.get("inheritedBP"), 0.0f, Misc.getPositiveHighlightColor(), Misc.getHighlightColor(), new String[]{"" + inheritedShip, "" + inheritedFighter, "" + inheritedWeapon, "" + inheritedHullmod});
    }

    @Override
    public void addSaverInfo(TooltipMakerAPI root, String descKey) {
        TooltipMakerAPI section = root.beginImageWithText("graphics/icons/reports/exports24.png", 24.0f);
        section.addPara(Constants.root_i18n.get(descKey + "_3"), 3.0f);
        root.addImageWithText(5.0f);
        root.addPara(Constants.root_i18n.get("data_bps"), 5.0f, Misc.getHighlightColor(), new String[]{"       " + this.ships.size(), "       " + this.fighters.size(), "       " + this.weapons.size(), "       " + this.hullmods.size()});
    }
}

