/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.other;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistIntel;

public class UNGP_WorkHard
extends UNGP_BaseRuleEffect
implements UNGP_CampaignTag {
    private static final String MEM_CHECK_WORK = "$UNGP_WorkHard_Warning";
    private static final float STRIKE_CHANCE_PER_DAY = 0.08f;
    private static final float CR_LOSS = 0.75f;
    private static final float CREW_LOSS = 0.5f;
    private float ratio;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.ratio = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(0.15f, 0.15f);
        }
        return 0.0f;
    }

    @Override
    public void advanceInCampaign(float amount, UNGP_CampaignPlugin.TempCampaignParams params) {
        float marine;
        CampaignFleetAPI fleet;
        float crew;
        float neededMarine;
        if (params.isOneDayPassed() && (neededMarine = (float)Math.ceil((crew = (crew = (float)(fleet = Global.getSector().getPlayerFleet()).getCargo().getCrew()) < 1.0f ? 1.0f : crew) * this.ratio - (marine = (float)fleet.getCargo().getMarines()))) > 0.0f) {
            if (!fleet.getMemoryWithoutUpdate().contains(MEM_CHECK_WORK)) {
                fleet.getMemoryWithoutUpdate().set(MEM_CHECK_WORK, (Object)true, 3.0f);
                String neededMarineString = "" + (int)neededMarine;
                Color negative = Misc.getNegativeHighlightColor();
                Color highlight = Misc.getHighlightColor();
                Global.getSector().getCampaignUI().addMessage(String.format(this.rule.getExtra2(), neededMarineString), negative, neededMarineString, "", highlight, highlight);
            }
            if (Math.random() < (double)0.08f) {
                WeightedRandomPicker picker = new WeightedRandomPicker();
                for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                    if (member.isMothballed()) continue;
                    picker.add((Object)member, member.getRepairTracker().getCR());
                }
                FleetMemberAPI notWorkHard = (FleetMemberAPI)picker.pickAndRemove();
                int deadCrew = notWorkHard.getCrewComposition().getCrewInt();
                while (deadCrew < 1) {
                    if (picker.isEmpty()) {
                        return;
                    }
                    notWorkHard = (FleetMemberAPI)picker.pickAndRemove();
                    deadCrew = notWorkHard.getCrewComposition().getCrewInt();
                }
                if (crew - (float)(deadCrew = Math.max(1, (int)((float)deadCrew * 0.5f))) <= 0.0f) {
                    return;
                }
                notWorkHard.getRepairTracker().applyCREvent(-0.75f, this.rule.getName());
                fleet.getCargo().removeCrew(deadCrew);
                UNGP_SpecialistIntel.RuleMessage message = new UNGP_SpecialistIntel.RuleMessage(this.rule, this.rule.getExtra1(), notWorkHard.getShipName(), "" + deadCrew);
                message.send();
            }
        }
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0f);
        }
        if (index == 1) {
            return "8%";
        }
        if (index == 2) {
            return "75%";
        }
        if (index == 3) {
            return "50%";
        }
        return null;
    }
}

