/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.other;

import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;

public class UNGP_StillGrowingUp
extends UNGP_BaseRuleEffect
implements UNGP_CampaignTag {
    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        int[] monthData = (int[])this.getDataInCampaign(0);
        if (monthData == null) {
            monthData = new int[]{0, 3};
            this.saveDataInCampaign(0, monthData);
        }
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0 || index == 1) {
            return "3";
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void advanceInCampaign(float amount, UNGP_CampaignPlugin.TempCampaignParams params) {
        if (params.isOneMonthPassed()) {
            int maxMonth;
            int elapsedMonth;
            int[] monthData = (int[])this.getDataInCampaign(0);
            if (monthData == null) {
                monthData = new int[]{0, 3};
            }
            if ((elapsedMonth = monthData[0] + 1) >= (maxMonth = monthData[1])) {
                UNGP_InGameData inGameData = UNGP_InGameData.getDataInSave();
                List<UNGP_RulesManager.URule> activatedRules = inGameData.getActivatedRules();
                List<UNGP_RulesManager.URule> allRules = UNGP_RulesManager.getAllRulesCopy();
                WeightedRandomPicker picker = new WeightedRandomPicker(this.getRandom());
                HashSet<String> addedRuleIDs = (HashSet<String>)this.getDataInCampaign(1);
                if (addedRuleIDs == null) {
                    addedRuleIDs = new HashSet<String>();
                    this.saveDataInCampaign(1, addedRuleIDs);
                }
                for (UNGP_RulesManager.URule uRule : allRules) {
                    if (!uRule.isPositive() || activatedRules.contains(uRule) || uRule.isGolden() || uRule.isMilestone() || !uRule.isRollable()) continue;
                    int weight = addedRuleIDs.contains(uRule.getId()) ? 1 : Math.min(6 - Math.abs(uRule.getCost()), 1);
                    picker.add((Object)uRule, (float)weight);
                }
                UNGP_RulesManager.URule toAdd = (UNGP_RulesManager.URule)picker.pick();
                if (toAdd != null) {
                    activatedRules.add(toAdd);
                    addedRuleIDs.add(toAdd.getId());
                    MessageIntel intel = new MessageIntel(this.rule.getName(), toAdd.getCorrectColor());
                    intel.setIcon(toAdd.getSpritePath());
                    intel.addLine(this.rule.getExtra1(), Misc.getTextColor(), new String[]{toAdd.getName()}, new Color[]{toAdd.getCorrectColor()});
                    intel.setSound("UNGP_still_growing_up_activate");
                    this.showMessage(intel);
                }
                inGameData.saveActivatedRules(activatedRules);
                UNGP_RulesManager.updateCacheNextFrame();
                monthData[0] = 0;
                monthData[1] = monthData[1] + 3;
            } else {
                monthData[0] = elapsedMonth;
            }
            MessageIntel intel = this.createMessage();
            intel.setIcon(this.rule.getSpritePath());
            intel.addLine(this.rule.getExtra2(), Misc.getTextColor(), new String[]{"" + (monthData[1] - monthData[0])}, new Color[]{Misc.getHighlightColor()});
            this.showMessage(intel);
            this.saveDataInCampaign(0, monthData);
        }
    }

    @Override
    public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
        int[] monthData = (int[])this.getDataInCampaign(0);
        if (monthData != null) {
            imageTooltip.addPara(this.rule.getExtra2(), 0.0f, Misc.getHighlightColor(), new String[]{"" + (monthData[1] - monthData[0])});
            return true;
        }
        return false;
    }
}

