/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.other;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.List;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;

public class UNGP_BirthdayPresent
extends UNGP_BaseRuleEffect
implements UNGP_CampaignTag {
    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        int[] giftTime = (int[])this.getDataInCampaign(0);
        if (giftTime == null) {
            CampaignClockAPI clock = Global.getSector().getClock();
            giftTime = new int[]{clock.getCycle() + 1, clock.getMonth(), clock.getDay()};
            this.saveDataInCampaign(0, giftTime);
        }
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return "1";
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void advanceInCampaign(float amount, UNGP_CampaignPlugin.TempCampaignParams params) {
        if (params.isOneDayPassed()) {
            int[] giftTime = (int[])this.getDataInCampaign(0);
            CampaignClockAPI clock = Global.getSector().getClock();
            if (giftTime != null) {
                if (clock.getCycle() == giftTime[0] && clock.getMonth() == giftTime[1] && clock.getDay() == giftTime[2]) {
                    UNGP_InGameData inGameData = UNGP_InGameData.getDataInSave();
                    List<UNGP_RulesManager.URule> activatedRules = inGameData.getActivatedRules();
                    List<UNGP_RulesManager.URule> allRules = UNGP_RulesManager.getAllRulesCopy();
                    WeightedRandomPicker picker = new WeightedRandomPicker(Misc.getRandom((long)(clock.getCycle() + clock.getMonth() + clock.getDay()), (int)inGameData.getCurCycle()));
                    for (UNGP_RulesManager.URule uRule : allRules) {
                        if (!uRule.isPositive() || activatedRules.contains(uRule) || !uRule.isRollable()) continue;
                        picker.add((Object)uRule, (float)Math.abs(uRule.getCost()));
                    }
                    UNGP_RulesManager.URule toAdd = (UNGP_RulesManager.URule)picker.pick();
                    activatedRules.remove(this.rule);
                    if (toAdd != null) {
                        activatedRules.add(toAdd);
                        MessageIntel intel = this.createMessage();
                        intel.setIcon(toAdd.getSpritePath());
                        intel.addLine(this.rule.getExtra1(), Misc.getTextColor(), new String[]{toAdd.getName()}, new Color[]{toAdd.getCorrectColor()});
                        this.showMessage(intel);
                        Global.getSoundPlayer().playUISound("UNGP_birthdaypresent_activate", 1.0f, 1.0f);
                    }
                    inGameData.saveActivatedRules(activatedRules);
                    UNGP_RulesManager.updateCacheNextFrame();
                }
            } else {
                giftTime = new int[]{clock.getCycle() + 1, clock.getMonth(), clock.getDay()};
                this.saveDataInCampaign(0, giftTime);
            }
        }
    }

    @Override
    public void cleanUp() {
        this.clearDataInCampaign(0);
    }

    @Override
    public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
        int[] giftTime = (int[])this.getDataInCampaign(0);
        if (giftTime != null) {
            imageTooltip.addPara(this.rule.getExtra2(), 0.0f, Misc.getHighlightColor(), new String[]{"" + giftTime[0], "" + giftTime[1], "" + giftTime[2]});
            return true;
        }
        return false;
    }
}

