/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.member;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_TtsInvicible
extends UNGP_MemberBuffRuleEffect {
    private static final float NORMAL_BONUS = 50.0f;
    private static final float DAMAGE_BONUS = 15.0f;
    private static final float CR_BONUS = 10.0f;

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(50.0f);
        }
        if (index == 1) {
            return this.getPercentString(15.0f);
        }
        if (index == 2) {
            return this.getPercentString(10.0f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
        MutableShipStatsAPI stats = member.getStats();
        String id = this.buffID;
        stats.getShieldUpkeepMult().modifyMult(id, 0.5f);
        stats.getShieldUnfoldRateMult().modifyPercent(id, 50.0f);
        stats.getShieldTurnRateMult().modifyPercent(id, 50.0f);
        stats.getEnergyWeaponDamageMult().modifyPercent(id, 15.0f);
        stats.getBallisticWeaponDamageMult().modifyPercent(id, 15.0f);
        stats.getMissileWeaponDamageMult().modifyPercent(id, 15.0f);
        stats.getEnergyRoFMult().modifyPercent(id, 15.0f);
        stats.getBallisticRoFMult().modifyPercent(id, 15.0f);
        stats.getMissileRoFMult().modifyPercent(id, 15.0f);
        stats.getMaxCombatReadiness().modifyFlat(id, 0.099999994f, this.rule.getName());
    }

    @Override
    public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
        imageTooltip.addPara(this.rule.getExtra1(), 0.0f);
        ArrayList<String> names = new ArrayList<String>();
        for (ShipHullSpecAPI hullSpec : Global.getSettings().getAllShipHullSpecs()) {
            if (!UNGP_TtsInvicible.isParagon(hullSpec) || hullSpec.isDefaultDHull()) continue;
            names.add(hullSpec.getNameWithDesignationWithDashClass());
        }
        imageTooltip.addPara(Misc.getAndJoined(names), Misc.getHighlightColor(), 5.0f);
        return true;
    }

    @Override
    public boolean canApply(FleetMemberAPI member) {
        return member.isFlagship() && UNGP_TtsInvicible.isParagon(member.getHullSpec());
    }

    public static boolean isParagon(ShipHullSpecAPI hullSpec) {
        return hullSpec.getHullId().contains("paragon") || hullSpec.getTags().contains("ungp_paragon");
    }
}

