/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.member;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_HssPhoenix
extends UNGP_MemberBuffRuleEffect {
    private static final float NORMAL_BONUS = 20.0f;
    private static final float MANEUVER_BONUS = 100.0f;
    private static final float CR_BONUS = 10.0f;

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(20.0f);
        }
        if (index == 1) {
            return this.getPercentString(100.0f);
        }
        if (index == 2) {
            return this.getPercentString(10.0f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
        MutableShipStatsAPI stats = member.getStats();
        String id = this.buffID;
        stats.getHullBonus().modifyPercent(id, 20.0f);
        stats.getArmorBonus().modifyPercent(id, 20.0f);
        stats.getFluxCapacity().modifyPercent(id, 20.0f);
        stats.getFluxDissipation().modifyPercent(id, 20.0f);
        stats.getMaxSpeed().modifyPercent(id, 100.0f);
        stats.getAcceleration().modifyPercent(id, 100.0f);
        stats.getDeceleration().modifyPercent(id, 100.0f);
        stats.getMaxTurnRate().modifyPercent(id, 100.0f);
        stats.getTurnAcceleration().modifyPercent(id, 100.0f);
        stats.getMaxCombatReadiness().modifyFlat(id, 0.099999994f, this.rule.getName());
    }

    @Override
    public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
        imageTooltip.addPara(this.rule.getExtra1(), 0.0f);
        ArrayList<String> names = new ArrayList<String>();
        for (ShipHullSpecAPI hullSpec : Global.getSettings().getAllShipHullSpecs()) {
            if (!UNGP_HssPhoenix.isOnslaught(hullSpec) || hullSpec.isDefaultDHull()) continue;
            names.add(hullSpec.getNameWithDesignationWithDashClass());
        }
        imageTooltip.addPara(Misc.getAndJoined(names), Misc.getHighlightColor(), 5.0f);
        return true;
    }

    @Override
    public boolean canApply(FleetMemberAPI member) {
        return member.isFlagship() && UNGP_HssPhoenix.isOnslaught(member.getHullSpec());
    }

    public static boolean isOnslaught(ShipHullSpecAPI hullSpec) {
        return hullSpec.getHullId().contains("onslaught") || hullSpec.getTags().contains("ungp_onslaught");
    }
}

