/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.member;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_EliteReserves
extends UNGP_MemberBuffRuleEffect
implements UNGP_PlayerFleetTag {
    private float maxBonus;
    private float curBonus;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.maxBonus = this.getValueByDifficulty(0, difficulty);
        this.curBonus = 0.0f;
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return 0.15f;
        }
        return 0.0f;
    }

    @Override
    public void applyPlayerFleetStats(CampaignFleetAPI fleet) {
        float crew = fleet.getCargo().getCrew();
        float minCrew = fleet.getFleetData().getMinCrew();
        float level = (crew - minCrew) / minCrew;
        level = Math.min(1.0f, Math.max(0.0f, level));
        this.curBonus = level * this.maxBonus;
    }

    @Override
    public void unapplyPlayerFleetStats(CampaignFleetAPI fleet) {
    }

    @Override
    public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
        member.getStats().getMaxCombatReadiness().modifyFlat(this.buffID, this.curBonus, this.rule.getName());
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0f);
        }
        return null;
    }
}

