/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.member;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatInitTag;
import ungp.api.rules.tags.UNGP_PlayerShipSkillTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_CruisingHunting
extends UNGP_BaseRuleEffect
implements UNGP_CombatInitTag,
UNGP_PlayerShipSkillTag {
    private static final int DP_REDUCTION_FLAT = 2;
    private float dpReductionFactor;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.dpReductionFactor = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(0.08f, 0.04f);
        }
        return super.getValueByDifficulty(index, difficulty);
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0f);
        }
        if (index == 1) {
            return "2";
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void init(CombatEngineAPI engine) {
    }

    @Override
    public void apply(FleetDataAPI fleetData, FleetMemberAPI member, MutableShipStatsAPI stats, ShipAPI.HullSize hullSize) {
        if (hullSize == ShipAPI.HullSize.CRUISER) {
            float dp = stats.getSuppliesToRecover().getBaseValue();
            int reduction = (int)Math.ceil(Math.max(2.0f, dp * this.dpReductionFactor));
            stats.getDynamic().getMod("deployment_points_mod").modifyFlat(this.buffID, (float)(-reduction));
        }
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize) {
        stats.getDynamic().getMod("deployment_points_mod").unmodify(this.buffID);
    }
}

