/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.fleet;

import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import java.util.ArrayList;
import java.util.List;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.utils.UNGP_BaseBuff;

public class UNGP_NavalTreaty
extends UNGP_BaseRuleEffect
implements UNGP_PlayerFleetTag {
    private static final int THRESHOLD_DESIGN_TYPE_AMOUNT = 2;
    private static final float MAX_CR_REDUCTION = 0.3f;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public void applyPlayerFleetStats(CampaignFleetAPI fleet) {
        ArrayList<String> designTypes = new ArrayList<String>();
        List members = fleet.getFleetData().getMembersListCopy();
        for (FleetMemberAPI member : members) {
            String designType;
            if (member.isMothballed() || UNGP_NavalTreaty.isCivilian(member) || designTypes.contains(designType = member.getHullSpec().getManufacturer())) continue;
            designTypes.add(designType);
        }
        float typeAmount = designTypes.size();
        if (typeAmount > 2.0f) {
            String buffId = this.buffID;
            boolean needsSync = false;
            float crReduction = 0.3f * (1.0f - 2.0f / typeAmount);
            for (FleetMemberAPI member : members) {
                CRDeBuff buff = (CRDeBuff)member.getBuffManager().getBuff(buffId);
                if (buff != null) {
                    buff.refresh();
                    buff.setCrReduction(crReduction);
                    continue;
                }
                member.getBuffManager().addBuff((BuffManagerAPI.Buff)new CRDeBuff(buffId, crReduction));
                needsSync = true;
            }
            if (needsSync) {
                fleet.forceSync();
            }
        }
    }

    @Override
    public void unapplyPlayerFleetStats(CampaignFleetAPI fleet) {
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return "2";
        }
        if (index == 1) {
            return "30%";
        }
        return super.getDescriptionParams(index, difficulty);
    }

    private class CRDeBuff
    extends UNGP_BaseBuff {
        private float crReduction;

        public CRDeBuff(String id, float crReduction) {
            super(id);
            this.crReduction = crReduction;
        }

        @Override
        public void apply(FleetMemberAPI member) {
            UNGP_NavalTreaty.decreaseMaxCR(member.getStats(), this.id, this.crReduction, UNGP_NavalTreaty.this.rule.getName());
        }

        public void setCrReduction(float crReduction) {
            this.crReduction = crReduction;
        }
    }
}

