/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.fleet;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.RepairTrackerAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.utils.UNGP_BaseBuff;

public class UNGP_Endurance
extends UNGP_BaseRuleEffect
implements UNGP_PlayerFleetTag {
    private float duration;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.duration = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(12.0f, -4.0f);
        }
        return super.getValueByDifficulty(index, difficulty);
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return "50%";
        }
        if (index == 1) {
            return this.getFactorString(this.getValueByDifficulty(0, difficulty));
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void applyPlayerFleetStats(CampaignFleetAPI fleet) {
        List members = fleet.getFleetData().getMembersListCopy();
        for (FleetMemberAPI member : members) {
            RepairTrackerAPI repairTracker;
            if (member.isMothballed() || member.getBuffManager().getBuff(this.buffID) != null || !((repairTracker = member.getRepairTracker()).getCR() < repairTracker.getMaxCR() * 0.5f)) continue;
            float crPer = member.getStats().getCRPerDeploymentPercent().computeEffective(member.getVariant().getHullSpec().getCRToDeploy()) / 100.0f;
            crPer = Math.min(crPer, repairTracker.getMaxCR() * 0.5f);
            repairTracker.applyCREvent(crPer, this.buffID, this.rule.getName());
            member.getBuffManager().addBuffOnlyUpdateStat((BuffManagerAPI.Buff)new UNGP_BaseBuff(this.buffID, this.duration));
        }
    }

    @Override
    public void unapplyPlayerFleetStats(CampaignFleetAPI fleet) {
    }

    @Override
    public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
        List members = Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy();
        boolean show = false;
        for (FleetMemberAPI member : members) {
            UNGP_BaseBuff buff = (UNGP_BaseBuff)member.getBuffManager().getBuff(this.buffID);
            if (buff == null) continue;
            imageTooltip.addPara(this.rule.getExtra1(), 0.0f, Misc.getHighlightColor(), new String[]{member.getShipName(), "" + (int)buff.getDur()});
            show = true;
        }
        return show;
    }
}

