/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.fleet;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.UNGP_MemberBuffRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_DisarmamentAgreement
extends UNGP_MemberBuffRuleEffect
implements UNGP_PlayerFleetTag {
    private static final float EXTRA_SUPPLIES_PENALTY = 20.0f;
    private int memberLimit;
    private int curMemberCount;
    private float curSuppliesPenalty;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.memberLimit = (int)this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return Math.round(difficulty.getLinearValue(20.0f, -5.0f));
        }
        if (index == 1) {
            return 20.0f;
        }
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getFactorString(this.getValueByDifficulty(index, difficulty));
        }
        if (index == 1) {
            return this.getPercentString(20.0f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void applyPlayerFleetMemberInCampaign(FleetMemberAPI member) {
        member.getStats().getSuppliesPerMonth().modifyPercent(this.getBuffID(), this.curSuppliesPenalty);
    }

    @Override
    public boolean canApply(FleetMemberAPI member) {
        return this.curMemberCount > this.memberLimit;
    }

    @Override
    public void applyPlayerFleetStats(CampaignFleetAPI fleet) {
        this.curMemberCount = fleet.getNumMembersFast();
        int diff = this.curMemberCount - this.memberLimit;
        this.curSuppliesPenalty = diff > 0 ? (float)diff * 20.0f : 0.0f;
    }

    @Override
    public void unapplyPlayerFleetStats(CampaignFleetAPI fleet) {
        this.curMemberCount = 0;
        this.curSuppliesPenalty = 0.0f;
    }
}

