/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.fleet;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.loading.CampaignPingSpec;
import java.awt.Color;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.utils.UNGP_BaseBuff;

public class UNGP_BustlingFungus
extends UNGP_BaseRuleEffect
implements UNGP_CampaignTag {
    private static final Color NOTICE_COLOR = new Color(0, 213, 140, 255);
    private static final float WAIT_DAY = 1.0f;
    private static final float REPAIR_RATE = 50.0f;
    private static final float SUPPLY_FACTOR = 0.5f;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public void advanceInCampaign(float amount, UNGP_CampaignPlugin.TempCampaignParams params) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet != null) {
            float vel = playerFleet.getCurrBurnLevel();
            if ((double)vel < 0.01) {
                Object mem = this.getDataInCampaign(0);
                if (mem == null) {
                    this.saveDataInCampaign(0, Float.valueOf(0.0f));
                } else {
                    float elapsed = ((Float)mem).floatValue();
                    if (elapsed >= 1.0f) {
                        String buffId = this.buffID;
                        boolean needsSync = false;
                        for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
                            BuffManagerAPI.Buff test = member.getBuffManager().getBuff(buffId);
                            if (test instanceof FungusBuff) {
                                FungusBuff buff = (FungusBuff)test;
                                buff.refresh();
                                continue;
                            }
                            member.getBuffManager().addBuff((BuffManagerAPI.Buff)new FungusBuff(buffId));
                            needsSync = true;
                        }
                        if (needsSync) {
                            playerFleet.forceSync();
                        }
                    } else {
                        float days = Global.getSector().getClock().convertToDays(amount);
                        this.saveDataInCampaign(0, Float.valueOf(elapsed += days));
                        if (elapsed >= 1.0f) {
                            playerFleet.addFloatingText(this.rule.getExtra1(), NOTICE_COLOR, 1.0f);
                            CampaignPingSpec custom = new CampaignPingSpec();
                            custom.setColor(NOTICE_COLOR);
                            custom.setWidth(10.0f);
                            custom.setRange(200.0f);
                            custom.setDuration(3.0f);
                            custom.setAlphaMult(0.25f);
                            custom.setInFraction(0.1f);
                            custom.setDelay(0.3f);
                            custom.setNum(3);
                            Global.getSector().addPing((SectorEntityToken)playerFleet, custom);
                            Global.getSoundPlayer().playUISound("UNGP_fungus_activate", 1.0f, 1.0f);
                        }
                    }
                }
            } else {
                this.clearDataInCampaign(0);
            }
        }
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return "1";
        }
        if (index == 1) {
            return "50%";
        }
        if (index == 2) {
            return "50%";
        }
        return super.getDescriptionParams(index, difficulty);
    }

    private class FungusBuff
    extends UNGP_BaseBuff {
        public FungusBuff(String id) {
            super(id);
        }

        @Override
        public void apply(FleetMemberAPI member) {
            member.getStats().getRepairRatePercentPerDay().modifyPercent(UNGP_BustlingFungus.this.buffID, 50.0f);
            member.getStats().getSuppliesPerMonth().modifyMult(UNGP_BustlingFungus.this.buffID, 0.5f);
        }
    }
}

