/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.fleet;

import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignListenerTag;
import ungp.api.rules.tags.UNGP_CampaignTag;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.scripts.campaign.everyframe.UNGP_CampaignPlugin;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.utils.UNGP_BaseBuff;

public class UNGP_BloodLust
extends UNGP_BaseRuleEffect
implements UNGP_CampaignTag,
UNGP_PlayerFleetTag,
UNGP_CampaignListenerTag<FleetBattleListener> {
    private static final float MAX_CR_REDUCTION = 0.15f;
    private int lustThresholdDay = 15;
    private boolean shouldApply = false;

    @Override
    public FleetBattleListener getListener() {
        return new FleetBattleListener();
    }

    @Override
    public Class<FleetBattleListener> getClassOfListener() {
        return FleetBattleListener.class;
    }

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.lustThresholdDay = (int)this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return Math.round(difficulty.getLinearValue(36.0f, -9.0f));
        }
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getFactorString(this.getValueByDifficulty(index, difficulty));
        }
        if (index == 1) {
            return this.getPercentString(15.000001f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void advanceInCampaign(float amount, UNGP_CampaignPlugin.TempCampaignParams params) {
        Integer dayPassed = (Integer)this.getDataInCampaign(0);
        if (params.isOneDayPassed()) {
            if (dayPassed == null) {
                dayPassed = 1;
            } else {
                Integer n = dayPassed;
                dayPassed = dayPassed + 1;
            }
            this.saveDataInCampaign(0, dayPassed);
        }
        if (dayPassed != null) {
            if (dayPassed >= this.lustThresholdDay) {
                if (!this.shouldApply) {
                    this.shouldApply = true;
                    MessageIntel message = this.createMessage();
                    message.addLine(this.rule.getExtra2(), Color.red);
                    this.showMessage(message);
                }
            } else {
                this.shouldApply = false;
            }
        }
    }

    @Override
    public void applyPlayerFleetStats(CampaignFleetAPI fleet) {
        if (this.shouldApply) {
            String buffId = this.buffID;
            boolean needsSync = false;
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                BuffManagerAPI.Buff test = member.getBuffManager().getBuff(buffId);
                if (test instanceof BloodLustBuff) {
                    BloodLustBuff buff = (BloodLustBuff)test;
                    buff.refresh();
                    continue;
                }
                member.getBuffManager().addBuff((BuffManagerAPI.Buff)new BloodLustBuff(buffId));
                needsSync = true;
            }
            if (needsSync) {
                fleet.forceSync();
            }
        }
    }

    @Override
    public void unapplyPlayerFleetStats(CampaignFleetAPI fleet) {
    }

    @Override
    public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
        Integer dayPassed = (Integer)this.getDataInCampaign(0);
        if (dayPassed == null) {
            dayPassed = 0;
        }
        if (this.shouldApply) {
            imageTooltip.addPara(this.rule.getExtra2(), Color.red, 0.0f);
        } else {
            imageTooltip.addPara(this.rule.getExtra1(), 0.0f, Misc.getHighlightColor(), new String[]{"" + (this.lustThresholdDay - dayPassed)});
        }
        return true;
    }

    @Override
    public void cleanUp() {
        this.clearDataInCampaign(0);
    }

    protected class FleetBattleListener
    implements FleetEventListener {
        protected FleetBattleListener() {
        }

        public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        }

        public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
            if (battle.isPlayerInvolved()) {
                UNGP_BloodLust.this.saveDataInCampaign(0, 0);
            }
        }
    }

    private class BloodLustBuff
    extends UNGP_BaseBuff {
        public BloodLustBuff(String id) {
            super(id);
        }

        @Override
        public void apply(FleetMemberAPI member) {
            UNGP_BloodLust.decreaseMaxCR(member.getStats(), UNGP_BloodLust.this.buffID, 0.15f, UNGP_BloodLust.this.rule.getName());
        }
    }
}

