/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.fleet;

import com.fs.starfarer.api.campaign.BuffManagerAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerFleetTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.utils.UNGP_BaseBuff;

public class UNGP_AncientThreat
extends UNGP_BaseRuleEffect
implements UNGP_PlayerFleetTag {
    private float reduction;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.reduction = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(0.1f, 0.05f);
        }
        return 0.0f;
    }

    @Override
    public void applyPlayerFleetStats(CampaignFleetAPI fleet) {
        if (fleet.getContainingLocation().hasTag("theme_remnant")) {
            boolean needsSync = false;
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                BuffManagerAPI.Buff test = member.getBuffManager().getBuff(this.buffID);
                if (test instanceof ThreatBuff) {
                    ThreatBuff buff = (ThreatBuff)test;
                    buff.refresh();
                    continue;
                }
                member.getBuffManager().addBuff((BuffManagerAPI.Buff)new ThreatBuff(this.buffID));
                needsSync = true;
            }
            if (needsSync) {
                fleet.forceSync();
            }
        }
    }

    @Override
    public void unapplyPlayerFleetStats(CampaignFleetAPI fleet) {
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0f);
        }
        return null;
    }

    private class ThreatBuff
    extends UNGP_BaseBuff {
        public ThreatBuff(String id) {
            super(id);
        }

        @Override
        public void apply(FleetMemberAPI member) {
            UNGP_AncientThreat.decreaseMaxCR(member.getStats(), this.id, UNGP_AncientThreat.this.reduction, UNGP_AncientThreat.this.rule.getName());
        }
    }
}

