/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.economy;

import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MutableCommodityQuantity;
import com.fs.starfarer.api.util.Misc;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_EconomyTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_IndustrialZone
extends UNGP_BaseRuleEffect
implements UNGP_EconomyTag {
    private static final int SIZE_THRESHOLD = 5;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public void applyPlayerMarket(MarketAPI market) {
        market.getStats().getDynamic().getMod("max_industries").unmodify(this.buffID);
        int curIndustries = Misc.getNumIndustries((MarketAPI)market);
        int maxIndustries = Misc.getMaxIndustries((MarketAPI)market);
        int size = market.getSize();
        if (size <= 5 && curIndustries > maxIndustries) {
            for (Industry industry : market.getIndustries()) {
                if (!industry.isIndustry()) continue;
                for (MutableCommodityQuantity commodityQuantity : industry.getAllSupply()) {
                    commodityQuantity.getQuantity().modifyFlat(this.buffID, -1.0f, this.rule.getName());
                }
            }
        } else {
            this.unapplyPlayerMarket(market);
        }
        market.getStats().getDynamic().getMod("max_industries").modifyFlat(this.buffID, 1.0f);
    }

    @Override
    public void unapplyPlayerMarket(MarketAPI market) {
        market.getStats().getDynamic().getMod("max_industries").unmodify(this.buffID);
        for (Industry industry : market.getIndustries()) {
            if (!industry.isIndustry()) continue;
            for (MutableCommodityQuantity commodityQuantity : industry.getAllSupply()) {
                commodityQuantity.getQuantity().unmodify(this.buffID);
            }
        }
    }

    @Override
    public void applyAllMarket(MarketAPI market) {
    }

    @Override
    public void unapplyAllMarket(MarketAPI market) {
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getFactorString(1.0f);
        }
        if (index == 1) {
            return this.getFactorString(5.0f);
        }
        if (index == 2) {
            return this.getFactorString(1.0f);
        }
        return null;
    }
}

