/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.economy;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MutableCommodityQuantity;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_EconomyTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_GLaDos
extends UNGP_BaseRuleEffect
implements UNGP_EconomyTag {
    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        Boolean sent = (Boolean)this.getDataInCampaign(0);
        if (sent == null) {
            Global.getSector().addTransientScript(new EveryFrameScript(){
                float duration = 2.0f + UNGP_GLaDos.access$000().nextFloat();
                boolean done = false;

                public boolean isDone() {
                    return this.done;
                }

                public boolean runWhilePaused() {
                    return false;
                }

                public void advance(float amount) {
                    this.duration -= amount;
                    if (this.duration <= 0.0f) {
                        MessageIntel message = UNGP_GLaDos.this.createMessage();
                        message.addLine(UNGP_GLaDos.this.rule.getExtra1(), Misc.getBasePlayerColor());
                        message.setSound("UNGP_glados_chosen");
                        UNGP_GLaDos.this.showMessage(message);
                        this.done = true;
                        Global.getSector().removeTransientScript((EveryFrameScript)this);
                    }
                }
            });
            this.saveDataInCampaign(0, true);
        }
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return 1.0f;
        }
        return super.getValueByDifficulty(index, difficulty);
    }

    @Override
    public void applyPlayerMarket(MarketAPI market) {
        for (Industry industry : market.getIndustries()) {
            if (industry.getAICoreId() != null && industry.getAICoreId().contentEquals("alpha_core")) {
                for (MutableCommodityQuantity mutableCommodityQuantity : industry.getAllSupply()) {
                    mutableCommodityQuantity.getQuantity().modifyFlat(this.buffID, 1.0f, this.rule.getName());
                }
                continue;
            }
            for (MutableCommodityQuantity mutableCommodityQuantity : industry.getAllSupply()) {
                mutableCommodityQuantity.getQuantity().unmodify(this.buffID);
            }
        }
    }

    @Override
    public void unapplyPlayerMarket(MarketAPI market) {
        for (Industry industry : market.getIndustries()) {
            for (MutableCommodityQuantity mutableCommodityQuantity : industry.getAllSupply()) {
                mutableCommodityQuantity.getQuantity().unmodify(this.buffID);
            }
        }
    }

    @Override
    public void applyAllMarket(MarketAPI market) {
    }

    @Override
    public void unapplyAllMarket(MarketAPI market) {
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getFactorString(1.0f);
        }
        return null;
    }

    static /* synthetic */ Random access$000() {
        return RANDOM;
    }
}

