/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.economy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyInteractionListener;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.submarkets.BlackMarketPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CampaignListenerTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_Fraudulent
extends UNGP_BaseRuleEffect
implements UNGP_CampaignListenerTag<MarketTransactionListener> {
    private static final float DROP_FACTOR = 0.2f;
    private float chance;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.chance = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(0.15f, 0.15f);
        }
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0f);
        }
        if (index == 1) {
            return this.getPercentString(20.0f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public MarketTransactionListener getListener() {
        return new MarketTransactionListener();
    }

    @Override
    public Class<MarketTransactionListener> getClassOfListener() {
        return MarketTransactionListener.class;
    }

    public class MarketTransactionListener
    implements ColonyInteractionListener {
        public void reportPlayerOpenedMarket(MarketAPI market) {
        }

        public void reportPlayerClosedMarket(MarketAPI market) {
        }

        public void reportPlayerOpenedMarketAndCargoUpdated(MarketAPI market) {
        }

        public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
            float creditValue;
            float rollChance = UNGP_Fraudulent.this.chance;
            if (transaction.getSubmarket() != null && transaction.getSubmarket().getPlugin() instanceof BlackMarketPlugin) {
                rollChance *= 2.0f;
            }
            if (UNGP_Fraudulent.this.roll(rollChance) && (creditValue = transaction.getCreditValue()) > 0.0f) {
                int dropCredit = (int)(creditValue * 0.2f);
                MessageIntel message = UNGP_Fraudulent.this.createMessage();
                message.addLine(UNGP_Fraudulent.this.rule.getExtra1(), Misc.getTextColor(), new String[]{Misc.getDGSCredits((float)dropCredit)}, new Color[]{Misc.getHighlightColor()});
                message.setSound("UNGP_fraudulent_activate");
                UNGP_Fraudulent.this.showMessage(message);
                Global.getSector().getPlayerFleet().getCargo().getCredits().subtract((float)dropCredit);
            }
        }
    }
}

