/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.loading.ProjectileSpawnType;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.ArrayList;
import java.util.Iterator;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_WholeShells
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private static final String LIST_ID = "UNGP_WholeShells";
    private static final IntervalUtil checkInterval = new IntervalUtil(0.1f, 0.1f);
    private static final float DAMAGE_MULTIPLIER = 0.5f;
    private float chance = 0.0f;
    private int decrease_amount = 0;
    private float total_damageReduction = 0.0f;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.chance = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(0.05f, 0.05f);
        }
        return 1.0f;
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
        ShipAPI player;
        checkInterval.advance(amount);
        if (checkInterval.intervalElapsed()) {
            ArrayList<DamagingProjectileAPI> recordedProjectile = (ArrayList<DamagingProjectileAPI>)UNGP_WholeShells.getDataInEngine(engine, LIST_ID);
            if (recordedProjectile == null) {
                recordedProjectile = new ArrayList<DamagingProjectileAPI>(50);
                this.decrease_amount = 0;
                this.total_damageReduction = 0.0f;
                UNGP_WholeShells.putDataInEngine(engine, LIST_ID, recordedProjectile);
            }
            for (DamagingProjectileAPI projectile : engine.getProjectiles()) {
                if (projectile.getOwner() != 0) continue;
                if (RANDOM.nextFloat() < this.chance) {
                    if (recordedProjectile.contains(projectile)) continue;
                    if (projectile.getSpawnType() == ProjectileSpawnType.BALLISTIC) {
                        float baseDamage = projectile.getBaseDamageAmount();
                        projectile.setDamageAmount(baseDamage * 0.5f);
                        ++this.decrease_amount;
                        this.total_damageReduction += baseDamage * 0.5f;
                    }
                }
                recordedProjectile.add(projectile);
            }
            Iterator recordIter = recordedProjectile.iterator();
            while (recordIter.hasNext()) {
                DamagingProjectileAPI proj = (DamagingProjectileAPI)recordIter.next();
                if (engine.isEntityInPlay((CombatEntityAPI)proj) && !proj.isExpired()) continue;
                recordIter.remove();
            }
        }
        if ((player = engine.getPlayerShip()) != null) {
            engine.maintainStatusForPlayerShip((Object)this.buffID, "graphics/icons/hullsys/ammo_feeder.png", this.rule.getName() + "(" + this.decrease_amount + ")", this.rule.getExtra1() + (int)this.total_damageReduction, true);
        }
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0f);
        }
        if (index == 1) {
            return this.getFactorString(0.5f);
        }
        return null;
    }
}

