/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatInitTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_VForVent
extends UNGP_BaseRuleEffect
implements UNGP_CombatInitTag {
    private static final float VENT_BONUS = 15.0f;
    private static final float BONUS_TIME = 0.33f;

    @Override
    public void init(CombatEngineAPI engine) {
        engine.addPlugin((EveryFrameCombatPlugin)new VTriggerPlugin());
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return Global.getSettings().getControlStringForEnumName("SHIP_VENT_FLUX");
        }
        if (index == 1) {
            return "0.33";
        }
        if (index == 2) {
            return "15%";
        }
        if (index == 3) {
            return "2";
        }
        return super.getDescriptionParams(index, difficulty);
    }

    private class VTriggerPlugin
    extends BaseEveryFrameCombatPlugin {
        private LinkedList<TimeRemaining> timeoutQueue = new LinkedList();
        private ShipAPI flagShip;
        private CombatEngineAPI engine;

        private VTriggerPlugin() {
        }

        public void init(CombatEngineAPI engine) {
            this.engine = engine;
        }

        public void advance(float amount, List<InputEventAPI> events) {
            if (this.engine.isPaused()) {
                return;
            }
            ShipAPI playerShip = this.engine.getPlayerShip();
            if (this.flagShip != playerShip) {
                if (this.flagShip != null) {
                    this.flagShip.getMutableStats().getVentRateMult().unmodify(UNGP_VForVent.this.buffID);
                }
                this.flagShip = playerShip;
                this.timeoutQueue.clear();
            }
            if (playerShip != null && playerShip.getFluxTracker().isVenting()) {
                int timeoutSize;
                for (InputEventAPI event : events) {
                    if (event.isConsumed() || !event.isControlUpEvent("SHIP_VENT_FLUX")) continue;
                    this.timeoutQueue.addLast(new TimeRemaining(0.33f));
                    float angle = MathUtils.getRandomNumberInRange((int)0, (int)360);
                    float radius = playerShip.getCollisionRadius() * MathUtils.getRandomNumberInRange((float)0.2f, (float)0.4f);
                    this.engine.spawnEmpArcVisual(MathUtils.getPointOnCircumference((Vector2f)playerShip.getLocation(), (float)radius, (float)angle), (CombatEntityAPI)playerShip, MathUtils.getPointOnCircumference((Vector2f)playerShip.getLocation(), (float)(radius * 2.0f), (float)angle), (CombatEntityAPI)playerShip, 10.0f, playerShip.getVentFringeColor(), playerShip.getVentCoreColor());
                    break;
                }
                if ((timeoutSize = this.timeoutQueue.size()) > 2) {
                    timeoutSize = 2;
                }
                if (timeoutSize > 0) {
                    Iterator iterator = this.timeoutQueue.iterator();
                    float maxRemaining = 0.0f;
                    while (iterator.hasNext()) {
                        TimeRemaining next = (TimeRemaining)iterator.next();
                        next.activeRemaining -= amount;
                        if (next.activeRemaining > maxRemaining) {
                            maxRemaining = next.activeRemaining;
                        }
                        if (!(next.activeRemaining < 0.0f)) continue;
                        iterator.remove();
                    }
                    playerShip.getMutableStats().getVentRateMult().modifyPercent(UNGP_VForVent.this.buffID, 15.0f * (float)timeoutSize);
                    this.engine.maintainStatusForPlayerShip((Object)UNGP_VForVent.this.buffID, "graphics/icons/tactical/venting_flux2.png", UNGP_VForVent.this.rule.getName(), String.format(UNGP_VForVent.this.rule.getExtra1(), "" + (float)((int)(maxRemaining * 100.0f)) / 100.0f), false);
                } else {
                    playerShip.getMutableStats().getVentRateMult().unmodify(UNGP_VForVent.this.buffID);
                }
            }
        }

        private class TimeRemaining {
            float activeRemaining;

            public TimeRemaining(float activeRemaining) {
                this.activeRemaining = activeRemaining;
            }
        }
    }
}

