/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.FighterWingAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_TwiceTheEffort
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private static final float REPLACEMENT_THRESHOLD = 0.5f;
    private float multiplier;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.multiplier = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(0.2f, 0.2f);
        }
        return 1.0f;
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
        if (ship.getNumFighterBays() > 0) {
            float replacementRate = ship.getSharedFighterReplacementRate();
            float level = (replacementRate - 0.5f) / 0.5f;
            level = 1.0f - Math.max(0.0f, level);
            for (FighterWingAPI wing : ship.getAllWings()) {
                for (ShipAPI fighter : wing.getWingMembers()) {
                    MutableShipStatsAPI stats = fighter.getMutableStats();
                    stats.getArmorDamageTakenMult().modifyMult(this.buffID, 1.0f + this.multiplier * level);
                    stats.getShieldDamageTakenMult().modifyMult(this.buffID, 1.0f + this.multiplier * level);
                    stats.getHullDamageTakenMult().modifyMult(this.buffID, 1.0f + this.multiplier * level);
                    stats.getBallisticWeaponDamageMult().modifyMult(this.buffID, 1.0f / (1.0f + this.multiplier * level));
                    stats.getEnergyWeaponDamageMult().modifyMult(this.buffID, 1.0f / (1.0f + this.multiplier * level));
                    stats.getMissileWeaponDamageMult().modifyMult(this.buffID, 1.0f / (1.0f + this.multiplier * level));
                }
            }
            if (ship == engine.getPlayerShip()) {
                engine.maintainStatusForPlayerShip((Object)this.buffID, this.rule.getSpritePath(), this.rule.getName(), this.rule.getExtra1() + (int)((1.0f - this.multiplier * level) * 100.0f) + "%", true);
            }
        }
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return "50%";
        }
        if (index == 1) {
            return this.getPercentString(this.getValueByDifficulty(0, difficulty) * 100.0f);
        }
        return null;
    }
}

