/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BattleObjectiveAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_TakeHighLand
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private static final float RANGE_BONUS = 20.0f;
    private float range;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.range = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return (int)difficulty.getLinearValue(2000.0f, 1000.0f);
        }
        return 1.0f;
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
        Vector2f shipLoc = ship.getLocation();
        boolean takeEffect = false;
        for (BattleObjectiveAPI tmp : Global.getCombatEngine().getObjectives()) {
            if (!MathUtils.isWithinRange((Vector2f)tmp.getLocation(), (Vector2f)shipLoc, (float)this.range)) continue;
            takeEffect = true;
            break;
        }
        MutableShipStatsAPI stats = ship.getMutableStats();
        if (takeEffect) {
            stats.getBallisticWeaponRangeBonus().modifyPercent(this.buffID, 20.0f);
            stats.getEnergyWeaponRangeBonus().modifyPercent(this.buffID, 20.0f);
            if (ship == engine.getPlayerShip()) {
                engine.maintainStatusForPlayerShip((Object)this.rule, "graphics/icons/sensor_array.png", this.rule.getName(), this.rule.getExtra1(), false);
            }
        } else {
            stats.getBallisticWeaponRangeBonus().unmodify(this.buffID);
            stats.getEnergyWeaponRangeBonus().unmodify(this.buffID);
        }
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getFactorString(this.getValueByDifficulty(index, difficulty));
        }
        if (index == 1) {
            return "20%";
        }
        return null;
    }
}

