/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.combat.listeners.HullDamageAboutToBeTakenListener;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatInitTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.utils.UNGPUtils;

public class UNGP_SymbolPerseus
extends UNGP_BaseRuleEffect
implements UNGP_CombatInitTag {
    public static final float MAX_TIME_PERIOD = 8.0f;
    public static final float TIME_TICK = 0.1f;
    public static final int MIN_KILL_COUNT = 2;
    public static final float FLUX_DECREASE_FACTOR = 0.15f;

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getFactorString(8.0f);
        }
        if (index == 1) {
            return this.getFactorString(2.0f);
        }
        if (index == 2) {
            return this.getPercentString(15.000001f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void init(CombatEngineAPI engine) {
        engine.getListenerManager().addListener((Object)new SymbolPerseusListener(engine));
    }

    public static class SymbolPerseusListener
    implements HullDamageAboutToBeTakenListener,
    AdvanceableListener {
        private final IntervalUtil interval = new IntervalUtil(0.1f, 0.1f);
        private final LinkedList<Integer> killCount = new LinkedList();
        private ShipAPI checkThisShipIfKilled = null;
        private int killCountInThisCheck = 0;

        public SymbolPerseusListener(final CombatEngineAPI engine) {
            int i = 0;
            while ((float)i < 80.0f) {
                this.killCount.add(0);
                ++i;
            }
            engine.addPlugin((EveryFrameCombatPlugin)new BaseEveryFrameCombatPlugin(){

                public void advance(float amount, List<InputEventAPI> events) {
                    if (engine.isPaused()) {
                        return;
                    }
                    this.advance(amount);
                }
            });
        }

        public void advance(float amount) {
            if (this.checkThisShipIfKilled != null) {
                if (!this.checkThisShipIfKilled.isAlive()) {
                    ++this.killCountInThisCheck;
                }
                this.checkThisShipIfKilled = null;
            }
            this.interval.advance(amount);
            if (this.interval.intervalElapsed()) {
                boolean allowBonus;
                this.killCount.removeFirst();
                this.killCount.addLast(this.killCountInThisCheck);
                int sum = 0;
                Iterator iterator = this.killCount.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    sum += i;
                }
                boolean bl = allowBonus = sum > 2;
                if (allowBonus && this.killCountInThisCheck > 0) {
                    ShipAPI player = Global.getCombatEngine().getPlayerShip();
                    player.getFluxTracker().decreaseFlux(player.getMaxFlux() * 0.15f);
                    player.setJitterUnder((Object)this, Color.CYAN, 2.0f, 5, 10.0f);
                    Global.getSoundPlayer().playSound("system_emp_emitter_impact", 1.0f, 1.0f, player.getLocation(), new Vector2f());
                }
                this.killCountInThisCheck = 0;
            }
        }

        public boolean notifyAboutToTakeHullDamage(Object param, ShipAPI ship, Vector2f point, float damageAmount) {
            float hull;
            if (UNGPUtils.isPlayerShip(ship)) {
                return false;
            }
            if (!ship.isAlive()) {
                return false;
            }
            if (ship.isFighter() || ship.isDrone()) {
                return false;
            }
            if (ship.isStation() || ship.isStationModule()) {
                return false;
            }
            if (param instanceof DamagingProjectileAPI) {
                DamagingProjectileAPI proj = (DamagingProjectileAPI)param;
                if (proj.getSource() != Global.getCombatEngine().getPlayerShip()) {
                    return false;
                }
            } else if (param instanceof BeamAPI) {
                BeamAPI beam = (BeamAPI)param;
                if (beam.getSource() != Global.getCombatEngine().getPlayerShip()) {
                    return false;
                }
            } else if (param instanceof CombatEntityAPI) {
                CombatEntityAPI entity = (CombatEntityAPI)param;
                if (entity != Global.getCombatEngine().getPlayerShip()) {
                    return false;
                }
            } else {
                return false;
            }
            if (damageAmount >= (hull = ship.getHitpoints())) {
                this.checkThisShipIfKilled = ship;
            }
            return false;
        }
    }
}

