/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_StrikerSchool
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private float rateMultiplier;
    private float replacementMultiplier;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.rateMultiplier = this.getValueByDifficulty(0, difficulty);
        this.replacementMultiplier = this.getValueByDifficulty(1, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(25.0f, 25.0f);
        }
        if (index == 1) {
            return difficulty.getLinearValue(20.0f, 20.0f);
        }
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty));
        }
        if (index == 1) {
            return this.getPercentString(this.getValueByDifficulty(0, difficulty));
        }
        if (index == 2) {
            return this.getPercentString(this.getValueByDifficulty(1, difficulty));
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
        MutableShipStatsAPI stats = enemy.getMutableStats();
        stats.getDynamic().getMod("replacement_rate_increase_mult").modifyPercent(this.buffID, this.rateMultiplier);
        stats.getDynamic().getMod("replacement_rate_decrease_mult").modifyMult(this.buffID, 1.0f - this.rateMultiplier * 0.01f);
        stats.getFighterRefitTimeMult().modifyMult(this.buffID, 1.0f - this.replacementMultiplier * 0.01f);
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
    }
}

