/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.CombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Iterator;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_StayCalm
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private static final String DATA_KEY = "UNGP_calm_data";
    private static final float PREDICT_TIME = 2.0f;
    private static final float HIT_POINTS_THRESHOLD = 0.2f;
    private static final float TIME_MULTIPLIER = 0.33f;
    private static final float COOL_DOWN = 15.0f;
    private static final float FADE_IN_SPEED = 10.0f;
    private static final float FADE_OUT_SPEED = 5.0f;
    private static final Color FRAME_COLOR = new Color(160, 0, 0);

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getFactorString(2.0f);
        }
        if (index == 1) {
            return this.getPercentString(20.0f);
        }
        if (index == 2) {
            return this.getPercentString(33.0f);
        }
        if (index == 3) {
            return this.getFactorString(2.0f);
        }
        if (index == 4) {
            return this.getFactorString(15.0f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
        ShipAPI player = engine.getPlayerShip();
        CalmData data = (CalmData)UNGP_StayCalm.getDataInEngine(engine, DATA_KEY);
        if (data == null) {
            data = new CalmData();
            UNGP_StayCalm.putDataInEngine(engine, DATA_KEY, data);
        }
        data.advance(engine, amount);
        if (data.state == CalmState.IDLE) {
            if (player != null) {
                data.setAffectedShip(player);
                if ((int)(data.elapsed * 10.0f) % 2 == 1) {
                    float damage = 0.0f;
                    Iterator iter = engine.getMissileGrid().getCheckIterator(player.getLocation(), 3000.0f, 3000.0f);
                    while (iter.hasNext()) {
                        MissileAPI tmp = (MissileAPI)iter.next();
                        if (tmp.didDamage() || tmp.isFizzling() || tmp.getOwner() == player.getOwner()) continue;
                        Vector2f predicted = new Vector2f((ReadableVector2f)tmp.getVelocity());
                        predicted.scale(2.0f);
                        Vector2f.add((Vector2f)predicted, (Vector2f)tmp.getLocation(), (Vector2f)predicted);
                        float distance = MathUtils.getDistance((CombatEntityAPI)player, (Vector2f)predicted);
                        boolean consider = false;
                        if (distance <= 0.0f) {
                            consider = true;
                        } else if (tmp.isGuided() && distance <= player.getCollisionRadius() * 2.0f) {
                            consider = true;
                        }
                        if (!consider) continue;
                        damage += tmp.getDamageAmount();
                    }
                    if (damage > player.getMaxHitpoints() * 0.2f) {
                        data.start();
                        final CalmData finalData = data;
                        engine.addLayeredRenderingPlugin((CombatLayeredRenderingPlugin)new BaseCombatLayeredRenderingPlugin(){
                            private float alphaLevel = 0.0f;

                            public void advance(float amount) {
                                this.alphaLevel = finalData.state == CalmState.ACTIVE ? Misc.interpolate((float)this.alphaLevel, (float)0.6f, (float)(10.0f * amount)) : Misc.interpolate((float)this.alphaLevel, (float)0.0f, (float)(5.0f * amount));
                            }

                            public boolean isExpired() {
                                return finalData.state == CalmState.IDLE;
                            }

                            public float getRenderRadius() {
                                return 10000.0f;
                            }

                            public void render(CombatEngineLayers layer, ViewportAPI viewport) {
                                if (this.alphaLevel > 0.05f) {
                                    Vector2f center = viewport.getCenter();
                                    float alpha = this.alphaLevel * viewport.getAlphaMult();
                                    float width = viewport.getVisibleWidth() * 1.1f;
                                    float height = viewport.getVisibleHeight() * 1.1f;
                                    SpriteAPI sprite = Global.getSettings().getSprite("fx", "UNGP_frame");
                                    sprite.setColor(FRAME_COLOR);
                                    sprite.setWidth(width);
                                    sprite.setHeight(height);
                                    sprite.setAdditiveBlend();
                                    sprite.setAlphaMult(alpha);
                                    sprite.renderAtCenter(center.x, center.y);
                                }
                            }
                        });
                    }
                }
            }
        } else {
            boolean isNegative;
            String format;
            if (data.state == CalmState.ACTIVE) {
                format = this.rule.getExtra1();
                isNegative = false;
            } else {
                format = this.rule.getExtra2();
                isNegative = true;
            }
            String content = String.format(format, String.format("%.1f", Float.valueOf(data.getRemainTime())));
            engine.maintainStatusForPlayerShip((Object)DATA_KEY, this.rule.getSpritePath(), this.rule.getName(), content, isNegative);
        }
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
    }

    private static final class CalmData {
        CalmState state = CalmState.IDLE;
        float elapsed = 0.0f;
        float effectLevel = 1.0f;
        ShipAPI affectedShip;

        private CalmData() {
        }

        void advance(CombatEngineAPI engine, float amount) {
            this.elapsed += amount;
            if (this.state == CalmState.ACTIVE) {
                this.effectLevel = Misc.interpolate((float)this.effectLevel, (float)0.33f, (float)(10.0f * amount));
                engine.getTimeMult().modifyMult(UNGP_StayCalm.DATA_KEY, this.effectLevel);
                if (this.affectedShip != null) {
                    this.affectedShip.getMutableStats().getTimeMult().modifyMult(UNGP_StayCalm.DATA_KEY, 1.0f / this.effectLevel);
                }
                if (this.elapsed > 2.0f) {
                    this.stop();
                }
            } else if (this.state == CalmState.COOLDOWN) {
                this.effectLevel = Misc.interpolate((float)this.effectLevel, (float)1.0f, (float)(10.0f * amount));
                engine.getTimeMult().modifyMult(UNGP_StayCalm.DATA_KEY, this.effectLevel);
                if (this.affectedShip != null) {
                    this.affectedShip.getMutableStats().getTimeMult().modifyMult(UNGP_StayCalm.DATA_KEY, 1.0f / this.effectLevel);
                }
                if (this.elapsed > 15.0f) {
                    this.state = CalmState.IDLE;
                    this.elapsed = 0.0f;
                    engine.getTimeMult().unmodify(UNGP_StayCalm.DATA_KEY);
                    if (this.affectedShip != null) {
                        this.affectedShip.getMutableStats().getTimeMult().unmodify(UNGP_StayCalm.DATA_KEY);
                    }
                }
            }
        }

        void setAffectedShip(ShipAPI ship) {
            if (this.affectedShip != null) {
                this.affectedShip.getMutableStats().getTimeMult().unmodify(UNGP_StayCalm.DATA_KEY);
            }
            this.affectedShip = ship;
        }

        void start() {
            this.state = CalmState.ACTIVE;
            this.elapsed = 0.0f;
            Global.getSoundPlayer().playUISound("UNGP_staycalm_start", 1.0f, 1.0f);
        }

        void stop() {
            this.state = CalmState.COOLDOWN;
            this.elapsed = 0.0f;
            Global.getSoundPlayer().playUISound("UNGP_staycalm_end", 1.0f, 1.0f);
        }

        float getRemainTime() {
            switch (this.state) {
                case IDLE: {
                    return 0.0f;
                }
                case ACTIVE: {
                    return 2.0f - this.elapsed;
                }
                case COOLDOWN: {
                    return 15.0f - this.elapsed;
                }
            }
            return 0.0f;
        }
    }

    private static enum CalmState {
        IDLE,
        ACTIVE,
        COOLDOWN;

    }
}

