/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.FogOfWarAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_Seer
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private static final Vector2f ZERO = new Vector2f();
    private static final float REVEAL_COOLDOWN = 20.0f;
    private float revealDuration;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.revealDuration = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return difficulty.getLinearValue(4.0f, 1.0f);
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return "20";
        }
        if (index == 1) {
            return this.getFactorString(this.getValueByDifficulty(index, difficulty));
        }
        return null;
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
        RevealData data = (RevealData)UNGP_Seer.getDataInEngine(engine, this.buffID);
        if (data == null) {
            data = new RevealData();
            UNGP_Seer.putDataInEngine(engine, this.buffID, data);
        }
        data.timeLeftForThisStage -= amount;
        if (data.timeLeftForThisStage <= 0.0f) {
            data.isEffecting = !data.isEffecting;
            float f = data.timeLeftForThisStage = data.isEffecting ? this.revealDuration : 20.0f;
            if (data.isEffecting) {
                Global.getSoundPlayer().playSound("world_sensor_burst_on", 1.0f, 1.0f, engine.getPlayerShip().getLocation(), ZERO);
            }
        }
        if (data.isEffecting) {
            float radiusEx = engine.getMapHeight() * 2.0f + engine.getMapWidth() * 2.0f;
            FogOfWarAPI fogOfWar = engine.getFogOfWar(0);
            if (fogOfWar != null) {
                fogOfWar.revealAroundPoint((Object)this, 0.0f, 0.0f, radiusEx);
            }
        }
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI ship) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
    }

    public static final class RevealData {
        float timeLeftForThisStage = 20.0f;
        boolean isEffecting = false;
    }
}

