/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.utils.UNGPUtils;

public class UNGP_PhasingGhost
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private float chance = 0.1f;

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
        GhostManager data = (GhostManager)UNGP_PhasingGhost.getDataInEngine(engine, this.buffID);
        if (data == null) {
            data = new GhostManager();
            UNGP_PhasingGhost.putDataInEngine(engine, this.buffID, data);
        }
        data.advance(engine, amount);
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
    }

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.chance = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(0.15f, 0.1f);
        }
        return super.getValueByDifficulty(index, difficulty);
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return "60";
        }
        if (index == 1) {
            return this.getPercentString(this.getValueByDifficulty(0, difficulty) * 100.0f);
        }
        if (index == 2) {
            return "0.5";
        }
        if (index == 3) {
            return "2";
        }
        return super.getDescriptionParams(index, difficulty);
    }

    protected String getVariant(String hullId) {
        List variants = Global.getSettings().getHullIdToVariantListMap().get((Object)hullId);
        WeightedRandomPicker variantPicker = new WeightedRandomPicker();
        if (!variants.isEmpty()) {
            variantPicker.addAll((Collection)variants);
        }
        return (String)variantPicker.pick();
    }

    private class GhostManager {
        private IntervalUtil checkInterval = new IntervalUtil(55.0f, 65.0f);
        private float rollChance;
        private String lastGeneratedHullId;

        private GhostManager() {
            this.rollChance = UNGP_PhasingGhost.this.chance;
        }

        public void advance(CombatEngineAPI engine, float amount) {
            this.checkInterval.advance(amount);
            ShipAPI.HullSize biggestHullSize = ShipAPI.HullSize.DEFAULT;
            if (this.checkInterval.intervalElapsed()) {
                if (UNGP_PhasingGhost.this.roll(this.rollChance)) {
                    Vector2f toSpawn = null;
                    WeightedRandomPicker spawnLocks = new WeightedRandomPicker();
                    for (ShipAPI ship : engine.getShips()) {
                        if (!ship.isAlive() || ship.isFighter()) continue;
                        ShipAPI.HullSize hullSize = ship.getHullSize();
                        if (biggestHullSize.ordinal() < hullSize.ordinal()) {
                            biggestHullSize = hullSize;
                        }
                        if (!UNGPUtils.isEnemyShip(ship)) continue;
                        spawnLocks.add((Object)ship);
                    }
                    if (!spawnLocks.isEmpty()) {
                        ShipAPI lockedPlaceShip = (ShipAPI)spawnLocks.pick();
                        float distance = MathUtils.getRandomNumberInRange((float)lockedPlaceShip.getCollisionRadius(), (float)(lockedPlaceShip.getCollisionRadius() * 3.0f));
                        toSpawn = MathUtils.getPointOnCircumference((Vector2f)lockedPlaceShip.getLocation(), (float)distance, (float)(RANDOM.nextFloat() * 360.0f));
                    }
                    if (toSpawn != null && biggestHullSize != ShipAPI.HullSize.DEFAULT) {
                        WeightedRandomPicker hullPicker = new WeightedRandomPicker();
                        switch (biggestHullSize) {
                            case FIGHTER: {
                                break;
                            }
                            case FRIGATE: {
                                hullPicker.add((Object)"afflictor", 10.0f);
                                hullPicker.add((Object)"shade", 10.0f);
                                break;
                            }
                            case DESTROYER: {
                                hullPicker.add((Object)"afflictor", 8.0f);
                                hullPicker.add((Object)"shade", 8.0f);
                                hullPicker.add((Object)"harbinger", 10.0f);
                                break;
                            }
                            case CRUISER: {
                                hullPicker.add((Object)"afflictor", 8.0f);
                                hullPicker.add((Object)"shade", 8.0f);
                                hullPicker.add((Object)"harbinger", 8.0f);
                                hullPicker.add((Object)"doom", 4.0f);
                                break;
                            }
                            case CAPITAL_SHIP: {
                                hullPicker.add((Object)"afflictor", 10.0f);
                                hullPicker.add((Object)"shade", 10.0f);
                                hullPicker.add((Object)"harbinger", 10.0f);
                                hullPicker.add((Object)"doom", 10.0f);
                            }
                        }
                        String hull = (String)hullPicker.pick();
                        if (hull != null) {
                            String variant;
                            int index;
                            if (this.lastGeneratedHullId != null && (index = hullPicker.getItems().indexOf(this.lastGeneratedHullId)) != -1) {
                                hullPicker.setWeight(index, hullPicker.getWeight(index) * 0.5f);
                            }
                            if ((variant = UNGP_PhasingGhost.this.getVariant(hull)) != null) {
                                CombatFleetManagerAPI fleetManager = engine.getFleetManager(FleetSide.ENEMY);
                                boolean wasSuppressed = fleetManager.isSuppressDeploymentMessages();
                                fleetManager.setSuppressDeploymentMessages(true);
                                ShipAPI spawnedGhost = fleetManager.spawnShipOrWing(variant, toSpawn, RANDOM.nextFloat() * 360.0f);
                                fleetManager.setSuppressDeploymentMessages(wasSuppressed);
                                engine.getCombatUI().addMessage(0, new Object[]{UNGP_PhasingGhost.this.rule.getCorrectColor(), UNGP_PhasingGhost.this.rule.getExtra1()});
                                Global.getSoundPlayer().playSound("UNGP_phasingghost_activate", 1.0f, 1.0f, toSpawn, new Vector2f());
                                Global.getSoundPlayer().playUISound("UNGP_phasingghost_warning", 1.0f, 0.4f);
                                engine.addPlugin((EveryFrameCombatPlugin)new PhasingFadeInPlugin(spawnedGhost));
                                this.rollChance *= 0.9f;
                                this.rollChance /= 2.0f;
                                this.lastGeneratedHullId = hull;
                            }
                        }
                    }
                } else {
                    this.rollChance *= 2.0f;
                }
            }
        }
    }

    private static class PhasingFadeInPlugin
    extends BaseEveryFrameCombatPlugin {
        public static Color JITTER_COLOR = new Color(61, 5, 122, 50);
        private static final float FADE_IN_TIME = 1.0f;
        private float elapsed;
        private ShipAPI ship;
        private CollisionClass collisionClass;

        public PhasingFadeInPlugin(ShipAPI ship) {
            this.ship = ship;
            this.collisionClass = ship.getCollisionClass();
            ship.setAlphaMult(0.0f);
        }

        public void advance(float amount, List<InputEventAPI> events) {
            float jitterLevel;
            if (Global.getCombatEngine().isPaused()) {
                return;
            }
            CombatEngineAPI engine = Global.getCombatEngine();
            this.elapsed += amount;
            float progress = Math.min(1.0f, this.elapsed / 1.0f);
            this.ship.setAlphaMult(progress);
            if (progress < 0.5f) {
                this.ship.blockCommandForOneFrame(ShipCommand.ACCELERATE);
                this.ship.blockCommandForOneFrame(ShipCommand.TURN_LEFT);
                this.ship.blockCommandForOneFrame(ShipCommand.TURN_RIGHT);
                this.ship.blockCommandForOneFrame(ShipCommand.STRAFE_LEFT);
                this.ship.blockCommandForOneFrame(ShipCommand.STRAFE_RIGHT);
            }
            this.ship.blockCommandForOneFrame(ShipCommand.USE_SYSTEM);
            this.ship.blockCommandForOneFrame(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK);
            this.ship.blockCommandForOneFrame(ShipCommand.FIRE);
            this.ship.blockCommandForOneFrame(ShipCommand.PULL_BACK_FIGHTERS);
            this.ship.blockCommandForOneFrame(ShipCommand.VENT_FLUX);
            this.ship.setHoldFireOneFrame(true);
            this.ship.setHoldFire(true);
            this.ship.setCollisionClass(CollisionClass.NONE);
            this.ship.getMutableStats().getHullDamageTakenMult().modifyMult("UNGP_PGFadeIn", 0.0f);
            if (progress > 0.75f) {
                this.ship.setCollisionClass(this.collisionClass);
                this.ship.getMutableStats().getHullDamageTakenMult().unmodifyMult("UNGP_PGFadeIn");
            }
            jitterLevel = (jitterLevel = progress) < 0.5f ? (jitterLevel *= 2.0f) : (1.0f - jitterLevel) * 2.0f;
            float jitterRange = 1.0f - progress;
            float maxRangeBonus = 50.0f;
            float jitterRangeBonus = jitterRange * maxRangeBonus;
            Color c = JITTER_COLOR;
            this.ship.setJitter((Object)this, c, jitterLevel, 25, 0.0f, jitterRangeBonus);
            if (this.elapsed > 1.0f) {
                this.ship.setAlphaMult(1.0f);
                this.ship.setHoldFire(false);
                this.ship.setCollisionClass(this.collisionClass);
                this.ship.getMutableStats().getHullDamageTakenMult().unmodifyMult("UNGP_PGFadeIn");
                engine.removePlugin((EveryFrameCombatPlugin)this);
            }
        }
    }
}

