/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_InfightingBook
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private float multiplier;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.multiplier = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(0.15f, 0.1f);
        }
        return 1.0f;
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
        if (!ship.hasListenerOfClass(InfightingBookDamageModifier.class)) {
            ship.addListener((Object)new InfightingBookDamageModifier());
        }
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return "500";
        }
        if (index == 1) {
            return this.getPercentString(this.getValueByDifficulty(0, difficulty) * 100.0f);
        }
        return null;
    }

    private class InfightingBookDamageModifier
    implements DamageDealtModifier {
        private InfightingBookDamageModifier() {
        }

        public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            if (param instanceof DamagingProjectileAPI) {
                WeaponAPI weapon = ((DamagingProjectileAPI)param).getWeapon();
                if (weapon != null && weapon.getSpec().getMaxRange() <= 500.0f) {
                    damage.getModifier().modifyMult(UNGP_InfightingBook.this.buffID, 1.0f + UNGP_InfightingBook.this.multiplier);
                    return UNGP_InfightingBook.this.buffID;
                }
            } else {
                return null;
            }
            return null;
        }
    }
}

