/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatAssignmentType;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.CombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatTaskManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.FastTrig;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatInitTag;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_Headhunting
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag,
UNGP_CombatInitTag {
    public static final float COOL_DOWN = 60.0f;
    public static final float DAMAGE_BONUS = 15.0f;
    private float maxDuration = 20.0f;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.maxDuration = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(21.0f, 6.0f);
        }
        return super.getValueByDifficulty(index, difficulty);
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getFactorString(this.getValueByDifficulty(index, difficulty));
        }
        if (index == 1) {
            return this.getPercentString(15.0f);
        }
        if (index == 2) {
            return this.getFactorString(60.0f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
        HeadhuntingData headHuntingData = (HeadhuntingData)UNGP_Headhunting.getDataInEngine(engine, "UNGP_headhunting_data");
        if (headHuntingData != null) {
            if (headHuntingData.remainCoolDown > 0.0f) {
                headHuntingData.remainCoolDown -= amount;
            }
            headHuntingData.checkInterval.advance(amount);
            if (headHuntingData.checkInterval.intervalElapsed()) {
                ShipAPI target;
                CombatFleetManagerAPI playerFleetManager = engine.getFleetManager(FleetSide.PLAYER);
                CombatTaskManagerAPI taskManager = playerFleetManager.getTaskManager(false);
                ArrayList<ShipAPI> allTargets = new ArrayList<ShipAPI>();
                for (CombatFleetManagerAPI.AssignmentInfo assignment : taskManager.getAllAssignments()) {
                    if (assignment.getType() != CombatAssignmentType.INTERCEPT || !(assignment.getTarget() instanceof DeployedFleetMemberAPI) || !(target = ((DeployedFleetMemberAPI)assignment.getTarget()).getShip()).isAlive()) continue;
                    allTargets.add(target);
                }
                List<ShipAPI> previousTargets = headHuntingData.previousTargets;
                ArrayList newTargets = new ArrayList(allTargets);
                newTargets.removeAll(previousTargets);
                if (headHuntingData.remainCoolDown <= 0.0f) {
                    if (!headHuntingData.showedRestoreMessage) {
                        headHuntingData.showedRestoreMessage = true;
                        engine.getCombatUI().addMessage(0, new Object[]{Misc.getPositiveHighlightColor(), this.rule.getExtra2()});
                        Global.getSoundPlayer().playUISound("UNGP_headhunting_charge", 1.0f, 1.0f);
                    }
                    if (!newTargets.isEmpty()) {
                        headHuntingData.remainCoolDown = 60.0f;
                        headHuntingData.showedRestoreMessage = false;
                        target = (ShipAPI)newTargets.get(0);
                        engine.addLayeredRenderingPlugin((CombatLayeredRenderingPlugin)new HeadhuntingStatusPlugin(target, this.maxDuration));
                        Global.getSoundPlayer().playUISound("UNGP_headhunting_activate", 1.0f, 1.0f);
                        engine.getCombatUI().addMessage(0, new Object[]{target, Misc.getNegativeHighlightColor(), target.getName() + "(" + target.getHullSpec().getHullNameWithDashClass() + ")", Misc.getHighlightColor(), this.rule.getExtra1()});
                    }
                }
                previousTargets.clear();
                previousTargets.addAll(allTargets);
            }
        }
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
    }

    @Override
    public void init(CombatEngineAPI engine) {
        UNGP_Headhunting.putDataInEngine(engine, "UNGP_headhunting_data", new HeadhuntingData());
    }

    private static class HeadhuntingData {
        private IntervalUtil checkInterval = new IntervalUtil(0.1f, 0.1f);
        private List<ShipAPI> previousTargets = new ArrayList<ShipAPI>();
        private float remainCoolDown = 0.0f;
        private boolean showedRestoreMessage = false;

        private HeadhuntingData() {
        }
    }

    private static class HeadhuntingStatusPlugin
    extends BaseCombatLayeredRenderingPlugin {
        public static final String HEADHUNTING_HUNTED = "UNGP_headhunting_hunted";
        private ShipAPI target;
        private float duration;
        private boolean isExpired;
        private float elapsed = 0.0f;
        private static int TEXTURE_ID = -1;

        public HeadhuntingStatusPlugin(ShipAPI target, float duration) {
            this.target = target;
            this.duration = duration;
            this.layer = CombatEngineLayers.BELOW_SHIPS_LAYER;
            if (TEXTURE_ID == -1) {
                SpriteAPI sprite = Global.getSettings().getSprite("fx", "UNGP_headhunting_target_edge");
                TEXTURE_ID = sprite.getTextureId();
            }
        }

        public void advance(float amount) {
            this.elapsed += amount;
            this.entity.getLocation().set((ReadableVector2f)this.target.getLocation());
            MutableShipStatsAPI stats = this.target.getMutableStats();
            if (this.elapsed > this.duration) {
                this.isExpired = true;
                stats.getEnergyDamageTakenMult().unmodify(HEADHUNTING_HUNTED);
                stats.getKineticDamageTakenMult().unmodify(HEADHUNTING_HUNTED);
                stats.getHighExplosiveDamageTakenMult().unmodify(HEADHUNTING_HUNTED);
                stats.getFragmentationDamageTakenMult().unmodify(HEADHUNTING_HUNTED);
                return;
            }
            Global.getCombatEngine().addHitParticle(this.target.getLocation(), new Vector2f(), 30.0f, 1.0f, 0.1f, Color.white);
            float multiplier = 1.15f;
            stats.getEnergyDamageTakenMult().modifyMult(HEADHUNTING_HUNTED, multiplier);
            stats.getKineticDamageTakenMult().modifyMult(HEADHUNTING_HUNTED, multiplier);
            stats.getHighExplosiveDamageTakenMult().modifyMult(HEADHUNTING_HUNTED, multiplier);
            stats.getFragmentationDamageTakenMult().modifyMult(HEADHUNTING_HUNTED, multiplier);
        }

        public void render(CombatEngineLayers layer, ViewportAPI viewport) {
            float imageSizeMultiplier = (float)(1.0 + (double)0.05f * FastTrig.sin((double)(this.elapsed * 2.0f)));
            float imageAngle = MathUtils.clampAngle((float)(-15.0f * this.elapsed));
            float imageAlphaMult = 1.0f;
            if (this.elapsed < 0.5f) {
                imageAlphaMult = this.elapsed / 0.5f;
            } else if (this.duration - this.elapsed < 0.5f) {
                imageAlphaMult = (this.duration - this.elapsed) / 0.5f;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.entity.getLocation().x, (float)this.entity.getLocation().y, (float)0.0f);
            GL11.glScalef((float)imageSizeMultiplier, (float)imageSizeMultiplier, (float)1.0f);
            GL11.glRotatef((float)imageAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            float outerRadius = this.target.getCollisionRadius();
            float innerRadius = outerRadius - 60.0f;
            float segments = 60.0f;
            float angle = 360.0f / segments;
            float texSeg = 4.0f;
            float texPerSeg = texSeg / segments;
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)2881);
            GL11.glHint((int)3155, (int)4354);
            GL11.glBindTexture((int)3553, (int)TEXTURE_ID);
            GL11.glBegin((int)5);
            Misc.setColor((Color)Color.white, (float)(0.5f * imageAlphaMult));
            int i = 0;
            while ((float)i <= segments) {
                float curAngle = angle * (float)i;
                float curTex = texPerSeg * (float)i;
                Vector2f innerPoint = MathUtils.getPointOnCircumference(null, (float)innerRadius, (float)curAngle);
                Vector2f outerPoint = MathUtils.getPointOnCircumference(null, (float)outerRadius, (float)curAngle);
                GL11.glTexCoord2f((float)curTex, (float)0.0f);
                GL11.glVertex2f((float)innerPoint.x, (float)innerPoint.y);
                GL11.glTexCoord2f((float)curTex, (float)1.0f);
                GL11.glVertex2f((float)outerPoint.x, (float)outerPoint.y);
                ++i;
            }
            GL11.glEnd();
            GL11.glDisable((int)2881);
            GL11.glPopMatrix();
        }

        public float getRenderRadius() {
            return this.target.getCollisionRadius() * 2.0f;
        }

        public boolean isExpired() {
            return this.isExpired || !this.target.isAlive();
        }
    }
}

