/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_GravityDisruptor
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private float playerMultiplier;
    private float enemyMultiplier;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.playerMultiplier = this.getValueByDifficulty(0, difficulty);
        this.enemyMultiplier = this.getValueByDifficulty(1, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(0.02f, 0.01f);
        }
        if (index == 1) {
            return difficulty.getLinearValue(0.01f, 0.01f);
        }
        return 1.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0 || index == 1) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
        enemy.getMutableStats().getTimeMult().modifyMult(this.buffID, 1.0f + this.enemyMultiplier);
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
        ship.getMutableStats().getTimeMult().modifyMult(this.buffID, 1.0f + this.playerMultiplier);
        if (engine.getPlayerShip() == ship) {
            engine.maintainStatusForPlayerShip((Object)this.buffID, this.rule.getSpritePath(), this.rule.getName(), String.format(this.rule.getExtra1(), this.getFactorString(1.0f + this.playerMultiplier)), false);
        }
    }
}

