/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_FragmentGraveyard
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private float velBonus;
    private float massBonus;
    private float breakProbBonus;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.velBonus = this.getValueByDifficulty(0, difficulty);
        this.massBonus = this.getValueByDifficulty(1, difficulty);
        this.breakProbBonus = this.getValueByDifficulty(2, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(4.0f, 2.0f);
        }
        if (index == 1) {
            return difficulty.getLinearValue(3.0f, 2.0f);
        }
        if (index == 2) {
            return difficulty.getLinearValue(50.0f, 50.0f);
        }
        return 1.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0f);
        }
        if (index == 1) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0f);
        }
        return null;
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
        for (ShipAPI ship : engine.getShips()) {
            if (ship.isAlive() || !ship.isHulk() || ship.getCustomData().containsKey(this.buffID)) continue;
            ship.setCustomData(this.buffID, (Object)true);
            ship.getVelocity().scale(this.velBonus);
            ship.setMass(ship.getMass() * this.massBonus);
        }
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI ship) {
        ship.getMutableStats().getBreakProb().modifyPercent(this.buffID, this.breakProbBonus);
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
        ship.getMutableStats().getBreakProb().modifyPercent(this.buffID, this.breakProbBonus);
    }
}

