/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_DangerZone
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private float spawnRateMult;
    private float poolMaxSize;
    private float cooldownRateMult;
    private static final Map<ShipAPI.HullSize, Float> BASE_SPAWN_TIME = new HashMap<ShipAPI.HullSize, Float>();
    private final WeightedRandomPicker<ShipAPI> cache = new WeightedRandomPicker();

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.spawnRateMult = this.getValueByDifficulty(0, difficulty);
        this.poolMaxSize = this.getValueByDifficulty(1, difficulty);
        this.cooldownRateMult = this.getValueByDifficulty(2, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(1.0f, 1.0f);
        }
        if (index == 1) {
            return difficulty.getLinearValue(10.0f, 6.0f);
        }
        if (index == 2) {
            return difficulty.getLinearValue(1.0f, 1.0f);
        }
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        float rate = this.getValueByDifficulty(0, difficulty);
        if (index == 0) {
            return this.getFactorString(BASE_SPAWN_TIME.get(ShipAPI.HullSize.FRIGATE).floatValue() / rate);
        }
        if (index == 1) {
            return this.getFactorString(BASE_SPAWN_TIME.get(ShipAPI.HullSize.DESTROYER).floatValue() / rate);
        }
        if (index == 2) {
            return this.getFactorString(BASE_SPAWN_TIME.get(ShipAPI.HullSize.CRUISER).floatValue() / rate);
        }
        if (index == 3) {
            return this.getFactorString(BASE_SPAWN_TIME.get(ShipAPI.HullSize.CAPITAL_SHIP).floatValue() / rate);
        }
        if (index == 4) {
            return "2000";
        }
        return null;
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI ship) {
        if (!ship.isAlive()) {
            return;
        }
        if (ship.isDrone() || ship.isFighter()) {
            return;
        }
        if (ship.isStation() || ship.isStationModule()) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        Float cooldownPool = (Float)UNGP_DangerZone.getDataInEngine(engine, this.buffID);
        if (cooldownPool == null) {
            cooldownPool = Float.valueOf(0.0f);
            UNGP_DangerZone.putDataInEngine(engine, this.buffID, cooldownPool);
        }
        cooldownPool = Float.valueOf(Math.max(cooldownPool.floatValue() - amount * this.cooldownRateMult, 0.0f));
        if (ship.getCustomData().get(this.buffID) == null) {
            float rate = BASE_SPAWN_TIME.get(ship.getHullSize()).floatValue() / this.spawnRateMult;
            ship.setCustomData(this.buffID, (Object)new IntervalUtil(rate, rate));
        }
        if (cooldownPool.floatValue() < this.poolMaxSize) {
            IntervalUtil timer = (IntervalUtil)ship.getCustomData().get(this.buffID);
            timer.advance(amount);
            if (timer.intervalElapsed()) {
                for (ShipAPI victim : AIUtils.getEnemiesOnMap((CombatEntityAPI)ship)) {
                    if (victim.isFighter() || victim.isDrone() || victim.isStation() || victim.isStationModule() || victim.getTravelDrive() != null && victim.getTravelDrive().isActive()) continue;
                    this.cache.add((Object)victim, (float)victim.getHullSize().ordinal());
                }
                ShipAPI victim = (ShipAPI)this.cache.pick();
                if (victim != null) {
                    this.cache.clear();
                    Vector2f target = UNGP_DangerZone.findClearLocation(victim);
                    if (target != null) {
                        UNGP_DangerZone.spawnMine(ship, target);
                        cooldownPool = Float.valueOf(cooldownPool.floatValue() + 1.0f);
                    }
                }
            }
        }
        UNGP_DangerZone.putDataInEngine(engine, this.buffID, cooldownPool);
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
    }

    public static void spawnMine(ShipAPI source, Vector2f mineLoc) {
        CombatEngineAPI engine = Global.getCombatEngine();
        Vector2f currLoc = Misc.getPointAtRadius((Vector2f)mineLoc, (float)(40.0f + (float)Math.random() * 80.0f));
        MissileAPI mine = (MissileAPI)engine.spawnProjectile(source, null, "minelayer2", currLoc, (float)Math.random() * 360.0f, null);
        if (source != null) {
            Global.getCombatEngine().applyDamageModifiersToSpawnedProjectileWithNullWeapon(source, WeaponAPI.WeaponType.MISSILE, false, mine.getDamage());
        }
        mine.setFlightTime((float)Math.random());
        mine.fadeOutThenIn(1.0f);
        Global.getSoundPlayer().playSound("mine_spawn", 1.0f, 1.0f, mine.getLocation(), mine.getVelocity());
    }

    public static Vector2f findClearLocation(ShipAPI victim) {
        ArrayList<Vector2f> tested = new ArrayList<Vector2f>();
        for (float angle = 0.0f; angle <= 360.0f; angle += 10.0f) {
            float minOk;
            Vector2f mineLoc = MathUtils.getRandomPointOnCircumference((Vector2f)victim.getLocation(), (float)(victim.getCollisionRadius() + 400.0f + 200.0f * (float)Math.random()));
            if (!UNGP_DangerZone.isAreaClear(mineLoc, minOk = 400.0f + victim.getCollisionRadius())) continue;
            tested.add(mineLoc);
        }
        if (tested.isEmpty()) {
            return null;
        }
        return (Vector2f)tested.get((int)(Math.random() * (double)tested.size()));
    }

    public static boolean isAreaClear(Vector2f loc, float range) {
        float dist;
        CombatEngineAPI engine = Global.getCombatEngine();
        for (ShipAPI other : engine.getShips()) {
            if (other.isFighter() || other.isDrone() || !((dist = Misc.getDistance((Vector2f)loc, (Vector2f)other.getLocation())) < range)) continue;
            return false;
        }
        for (ShipAPI other : Global.getCombatEngine().getAsteroids()) {
            dist = Misc.getDistance((Vector2f)loc, (Vector2f)other.getLocation());
            if (!(dist < other.getCollisionRadius() + 100.0f)) continue;
            return false;
        }
        return true;
    }

    static {
        BASE_SPAWN_TIME.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(10.0f));
        BASE_SPAWN_TIME.put(ShipAPI.HullSize.CRUISER, Float.valueOf(14.0f));
        BASE_SPAWN_TIME.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(20.0f));
        BASE_SPAWN_TIME.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(30.0f));
    }
}

