/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_CriticalHit
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private static final float CRITICAL_HIT_CHANCE = 0.05f;

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(5.0f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
        if (engine.getPlayerShip() == ship) {
            if (!ship.hasListenerOfClass(CriticalHitListener.class)) {
                ship.addListener((Object)new CriticalHitListener());
            }
        } else {
            ship.removeListenerOfClass(CriticalHitListener.class);
        }
    }

    private class CriticalHitListener
    implements DamageDealtModifier {
        private CriticalHitListener() {
        }

        public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            if (UNGP_CriticalHit.this.roll(0.05f)) {
                if (damage.getDamage() >= 100.0f) {
                    Global.getCombatEngine().addFloatingText(point, i18n.get("ct"), 30.0f, Color.red, target, 1.0f, 0.0f);
                }
                damage.getModifier().modifyMult(UNGP_CriticalHit.this.buffID, 2.0f);
                return UNGP_CriticalHit.this.buffID;
            }
            return null;
        }
    }
}

