/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.combat.listeners.DamageListener;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatInitTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.utils.UNGPUtils;

public class UNGP_Collector
extends UNGP_BaseRuleEffect
implements UNGP_CombatInitTag {
    public static final float COLLECT_HP_THRESHOLD = 0.05f;

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return "5%";
        }
        if (index == 1) {
            return Misc.getDGSCredits((float)25.0f);
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void init(CombatEngineAPI engine) {
        engine.getListenerManager().addListener((Object)new CollectorListener(engine));
    }

    public static class CollectorListener
    implements DamageListener {
        public static final String DEBUFF_ID = "UNGP_collector_debuff";
        private float hiddenCoolDown = 0.0f;

        public CollectorListener(final CombatEngineAPI engine) {
            engine.addPlugin((EveryFrameCombatPlugin)new BaseEveryFrameCombatPlugin(){

                public void advance(float amount, List<InputEventAPI> events) {
                    if (engine.isPaused()) {
                        return;
                    }
                    this.advance(amount);
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void reportDamageApplied(Object source, CombatEntityAPI target, ApplyDamageResultAPI result) {
            Vector2f damagePoint;
            int[] cellAtLocation;
            if (this.hiddenCoolDown > 0.0f) {
                return;
            }
            if (!(source instanceof ShipAPI)) return;
            if (!(target instanceof ShipAPI)) return;
            if (source == target) return;
            ShipAPI dmgSourceShip = (ShipAPI)source;
            if (!UNGPUtils.isPlayerShip(dmgSourceShip)) {
                return;
            }
            ShipAPI dmgTargetShip = (ShipAPI)target;
            if (!dmgTargetShip.isAlive()) return;
            if (dmgTargetShip.isFighter()) return;
            if (dmgSourceShip.getOwner() == dmgTargetShip.getOwner()) return;
            if (!(result.getDamageToHull() > 0.0f)) return;
            CombatEngineAPI engine = Global.getCombatEngine();
            ShipAPI playerShip = engine.getPlayerShip();
            if (dmgTargetShip == playerShip) {
                return;
            }
            if (dmgSourceShip.isFighter()) {
                if (dmgSourceShip.getWing() == null) return;
                if (dmgSourceShip.getWing().getSourceShip() != playerShip) {
                    return;
                }
            } else if (dmgSourceShip != playerShip) {
                return;
            }
            if (!(target.getHullLevel() < 0.05f)) return;
            ArmorGridAPI armorGrid = dmgTargetShip.getArmorGrid();
            int check = 20;
            Vector2f targetLocation = target.getLocation();
            do {
                if (check <= 0) return;
                --check;
            } while ((cellAtLocation = armorGrid.getCellAtLocation(damagePoint = MathUtils.getRandomPointInCircle((Vector2f)targetLocation, (float)target.getCollisionRadius()))) == null);
            MutableShipStatsAPI stats = dmgTargetShip.getMutableStats();
            stats.getMinArmorFraction().modifyMult(DEBUFF_ID, 0.0f);
            this.clearArmor(cellAtLocation[0], cellAtLocation[1], armorGrid);
            float damage = target.getMaxHitpoints() * 0.05f + 999.0f;
            dmgTargetShip.setHitpoints(1.0f);
            engine.applyDamage(target, targetLocation, damage, result.getType(), 0.0f, true, false, (Object)dmgSourceShip, true);
            stats.getMinArmorFraction().unmodify(DEBUFF_ID);
            this.hiddenCoolDown = 0.15f;
            Global.getSoundPlayer().playSound("UNGP_collector_activate", 1.0f, 1.0f, targetLocation, Misc.ZERO);
            if (engine.isInCampaignSim()) return;
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            if (playerFleet == null) return;
            playerFleet.getCargo().getCredits().add(25.0f);
            engine.addFloatingText(targetLocation, "+" + Misc.getDGSCredits((float)25.0f), 50.0f, Color.yellow, null, 0.0f, 0.0f);
        }

        public void advance(float amount) {
            if (this.hiddenCoolDown > 0.0f) {
                this.hiddenCoolDown -= amount;
            }
        }

        private void clearArmor(int x, int y, ArmorGridAPI grid) {
            int gridWidth = grid.getGrid().length;
            int gridHeight = grid.getGrid()[0].length;
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    if (!(i != 2 && i != -2 || j != 2 && j != -2)) continue;
                    int cx = x + i;
                    int cy = y + j;
                    if (cx < 0 || cx >= gridWidth || cy < 0 || cy >= gridHeight) continue;
                    grid.setArmorValue(cx, cy, 0.0f);
                }
            }
        }
    }
}

