/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import java.util.List;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_CloseFormation
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private static final float RANGE = 600.0f;
    private static final float MULTIPLIER = 1.1f;

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return 0.0f;
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
        boolean isEffective = false;
        List nearbyShips = CombatUtils.getShipsWithinRange((Vector2f)ship.getLocation(), (float)600.0f);
        if (!nearbyShips.isEmpty()) {
            for (ShipAPI nearby : nearbyShips) {
                if (nearby.isFighter() || nearby.getOwner() != ship.getOwner()) continue;
                isEffective = true;
                break;
            }
        }
        MutableShipStatsAPI stats = ship.getMutableStats();
        if (isEffective) {
            stats.getFluxDissipation().modifyMult(this.buffID, 1.1f);
            stats.getShieldDamageTakenMult().modifyMult(this.buffID, 0.9090909f);
            if (ship == engine.getPlayerShip()) {
                engine.maintainStatusForPlayerShip((Object)this.buffID, this.rule.getSpritePath(), this.rule.getName(), this.rule.getExtra1() + this.getFactorString(1.1f), false);
            }
        } else {
            stats.getFluxDissipation().unmodify(this.buffID);
            stats.getShieldDamageTakenMult().unmodify(this.buffID);
        }
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getFactorString(600.0f);
        }
        if (index == 1) {
            return this.getFactorString(1.1f);
        }
        return null;
    }
}

