/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_CenturyWar
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private float damageMultiplier;
    private float rangeBonus;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.damageMultiplier = 1.0f - this.getValueByDifficulty(0, difficulty) * 0.01f;
        this.rangeBonus = this.getValueByDifficulty(1, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(20.0f, 10.0f);
        }
        if (index == 1) {
            return difficulty.getLinearValue(30.0f, 20.0f);
        }
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty));
        }
        if (index == 1) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty));
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
        boolean shouldApply = false;
        if (enemy.isStation()) {
            shouldApply = true;
        } else if (enemy.isStationModule() && enemy.getParentStation().isStation()) {
            shouldApply = true;
        }
        if (shouldApply) {
            MutableShipStatsAPI stats = enemy.getMutableStats();
            stats.getHullDamageTakenMult().modifyMult(this.buffID, this.damageMultiplier);
            stats.getArmorDamageTakenMult().modifyMult(this.buffID, this.damageMultiplier);
            stats.getShieldDamageTakenMult().modifyMult(this.buffID, this.damageMultiplier);
            stats.getEnergyWeaponRangeBonus().modifyPercent(this.buffID, this.rangeBonus);
            stats.getBallisticWeaponRangeBonus().modifyPercent(this.buffID, this.rangeBonus);
        }
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
    }
}

