/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_BlockedFluxConduits
extends UNGP_BaseRuleEffect
implements UNGP_CombatTag {
    private float fluxReduction = 15.0f;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.fluxReduction = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(15.0f, 10.0f);
        }
        return 0.0f;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty));
        }
        return super.getDescriptionParams(index, difficulty);
    }

    @Override
    public void advanceInCombat(CombatEngineAPI engine, float amount) {
    }

    @Override
    public void applyEnemyShipInCombat(float amount, ShipAPI enemy) {
    }

    @Override
    public void applyPlayerShipInCombat(float amount, CombatEngineAPI engine, ShipAPI ship) {
        ShieldAPI shield = ship.getShield();
        if (shield != null) {
            MutableShipStatsAPI stats = ship.getMutableStats();
            if (shield.isOn()) {
                float arcLevel = 1.0f - shield.getActiveArc() / shield.getArc();
                arcLevel = Math.min(Math.max(0.0f, arcLevel), 1.0f);
                arcLevel *= arcLevel;
                arcLevel = 1.0f - arcLevel;
                float finalReduction = this.fluxReduction * arcLevel;
                stats.getFluxDissipation().modifyPercent(this.buffID, -finalReduction);
                if (engine.getPlayerShip() == ship) {
                    engine.maintainStatusForPlayerShip((Object)this.buffID, this.rule.getSpritePath(), this.rule.getName(), this.rule.getExtra1() + (int)finalReduction + "%", true);
                }
            } else {
                stats.getFluxDissipation().unmodify(this.buffID);
            }
        }
    }
}

