/*
 * Decompiled with CFR 0.152.
 */
package ungp.impl.rules.character;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import ungp.api.rules.UNGP_BaseRuleEffect;
import ungp.api.rules.tags.UNGP_PlayerCharacterStatsSkillTag;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;

public class UNGP_TechRevolution
extends UNGP_BaseRuleEffect
implements UNGP_PlayerCharacterStatsSkillTag {
    public static final float MAXIMUM_CYCLE = 4.0f;
    private float bonus;

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.bonus = this.getValueByDifficulty(0, difficulty);
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return difficulty.getLinearValue(0.08f, 0.02f);
        }
        return super.getValueByDifficulty(index, difficulty);
    }

    @Override
    public void apply(MutableCharacterStatsAPI stats) {
        stats.getShipOrdnancePointBonus().modifyPercent(this.buffID, this.bonus * 100.0f * this.getBonusFactor());
    }

    private float getBonusFactor() {
        Long latestTimestamp = (Long)this.getDataInCampaign(0);
        if (latestTimestamp == null) {
            latestTimestamp = Global.getSector().getClock().getTimestamp();
            this.saveDataInCampaign(0, latestTimestamp);
        }
        long exTime = Math.max(0L, Global.getSector().getClock().getTimestamp() - latestTimestamp);
        float cycleFactor = 0.0f;
        if (exTime > 0L) {
            cycleFactor = (float)exTime / 1000.0f / 60.0f / 60.0f / 24.0f / 365.0f;
            cycleFactor *= 0.25f;
        }
        return Math.min(1.0f, 0.25f + 0.75f * cycleFactor);
    }

    @Override
    public void unapply(MutableCharacterStatsAPI stats) {
        stats.getShipOrdnancePointBonus().unmodify(this.buffID);
    }

    @Override
    public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
        imageTooltip.addPara(this.rule.getExtra1(), 0.0f);
        imageTooltip.addPara((int)(this.getBonusFactor() * 100.0f) + "%", Misc.getHighlightColor(), 0.0f);
        return super.addIntelTips(imageTooltip);
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        if (index == 0) {
            return this.getPercentString(this.getValueByDifficulty(index, difficulty) * 100.0f);
        }
        if (index == 1) {
            return this.getPercentString(25.0f);
        }
        if (index == 2) {
            return "4";
        }
        return super.getDescriptionParams(index, difficulty);
    }
}

