/*
 * Decompiled with CFR 0.152.
 */
package ungp.api.rules;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import java.math.BigDecimal;
import java.util.Random;
import org.jetbrains.annotations.Nullable;
import ungp.api.rules.UNGP_RuleEffectAPI;
import ungp.scripts.campaign.UNGP_SharedData;
import ungp.scripts.campaign.specialist.UNGP_PlayerFleetMemberBuff;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistIntel;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.utils.SimpleI18n;

public abstract class UNGP_BaseRuleEffect
implements UNGP_RuleEffectAPI {
    protected static final Random RANDOM = new Random();
    protected static final SimpleI18n.I18nSection i18n = new SimpleI18n.I18nSection("UNGP_rule_impl", "", false);
    protected UNGP_RulesManager.URule rule;
    protected String buffID;

    public boolean roll(float chance) {
        return this.roll(RANDOM, chance);
    }

    public boolean roll(Random random, float chance) {
        return random.nextFloat() < chance;
    }

    public boolean roll2() {
        return RANDOM.nextBoolean();
    }

    public void setRule(UNGP_RulesManager.URule rule) {
        this.rule = rule;
        this.buffID = "UNGP_" + rule.getId();
    }

    @Override
    public UNGP_RulesManager.URule getRule() {
        return this.rule;
    }

    @Deprecated
    public void updateDifficultyCache(int legacyLevel) {
    }

    @Override
    public void updateDifficultyCache(UNGP_SpecialistSettings.Difficulty difficulty) {
        this.updateDifficultyCache(difficulty.legacyLevel);
    }

    @Deprecated
    public float getValueByDifficulty(int index, int legacyLevel) {
        return 0.0f;
    }

    @Override
    public float getValueByDifficulty(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return this.getValueByDifficulty(index, difficulty.legacyLevel);
    }

    @Deprecated
    public String getDescriptionParams(int index) {
        return null;
    }

    @Deprecated
    public String getDescriptionParams(int index, int legacyLevel) {
        return null;
    }

    @Override
    public String getDescriptionParams(int index, UNGP_SpecialistSettings.Difficulty difficulty) {
        return this.getDescriptionParams(index, difficulty.legacyLevel);
    }

    @Override
    public void applyGlobalStats() {
    }

    @Override
    public void unapplyGlobalStats() {
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public boolean addIntelTips(TooltipMakerAPI imageTooltip) {
        return false;
    }

    @Deprecated
    protected float getLinearValue(float min, float max, int legacyLevel) {
        UNGP_SpecialistSettings.Difficulty difficulty = UNGP_SpecialistSettings.Difficulty.convertLegacyLevelToDifficulty(legacyLevel);
        if (difficulty != null) {
            return difficulty.getLinearValue(min, max - min);
        }
        return 0.0f;
    }

    protected String getPercentString(float value) {
        BigDecimal number = new BigDecimal(String.format("%.1f", Float.valueOf(value)));
        return number.stripTrailingZeros().toPlainString() + "%";
    }

    protected String getFactorString(float value) {
        BigDecimal number = new BigDecimal(String.format("%.2f", Float.valueOf(value)));
        return number.stripTrailingZeros().toPlainString();
    }

    protected MessageIntel createMessage() {
        MessageIntel message = new MessageIntel(this.rule.getName(), this.rule.getCorrectColor());
        message.setIcon(this.rule.getSpritePath());
        return message;
    }

    protected void showMessage(MessageIntel intel) {
        InteractionDialogAPI dialog;
        CampaignUIAPI campaignUI = Global.getSector().getCampaignUI();
        if (campaignUI == null) {
            return;
        }
        if (campaignUI.isShowingDialog() && (dialog = campaignUI.getCurrentInteractionDialog()) != null && dialog.getTextPanel() != null) {
            Global.getSector().getIntelManager().addIntelToTextPanel((IntelInfoPlugin)intel, dialog.getTextPanel());
        }
        campaignUI.addMessage((IntelInfoPlugin)intel, CommMessageAPI.MessageClickAction.INTEL_TAB, (Object)UNGP_SpecialistIntel.getInstance());
    }

    protected static <T> T getDataInEngine(CombatEngineAPI engine, String key) {
        Object record = engine.getCustomData().get(key);
        if (record != null) {
            return (T)record;
        }
        return null;
    }

    protected static <T> void putDataInEngine(CombatEngineAPI engine, String key, T t) {
        engine.getCustomData().put(key, t);
    }

    protected static void decreaseMaxCR(MutableShipStatsAPI memberStats, String id, float flat, String desc) {
        float curMaxCR = memberStats.getMaxCombatReadiness().getModifiedValue();
        float multiplier = memberStats.getMaxCombatReadiness().computeMultMod();
        float toDecrease = Math.min(flat, curMaxCR / multiplier);
        memberStats.getMaxCombatReadiness().modifyFlat(id, -toDecrease, desc);
    }

    protected static <T> void saveDataInCampaign(String key, T t) {
        UNGP_SharedData.saveRuleData(key, t);
    }

    protected <T> void saveDataInCampaign(int slot, T t) {
        UNGP_BaseRuleEffect.saveDataInCampaign(this.rule.getId() + slot, t);
    }

    protected static <T> T getDataInCampaign(String key) {
        return UNGP_SharedData.loadRuleData(key);
    }

    @Nullable
    protected <T> T getDataInCampaign(int slot) {
        return UNGP_BaseRuleEffect.getDataInCampaign(this.rule.getId() + slot);
    }

    protected void clearDataInCampaign(int slot) {
        UNGP_SharedData.clearRuleData(this.rule.getId() + slot);
    }

    protected Random getRandom() {
        CampaignClockAPI clock = Global.getSector().getClock();
        return new Random((Global.getSector().getSeedString() + this.rule.getId() + clock.getCycle() + clock.getMonth()).hashCode());
    }

    protected Random getRandomByDay() {
        CampaignClockAPI clock = Global.getSector().getClock();
        return new Random((Global.getSector().getSeedString() + this.rule.getId() + clock.getCycle() + clock.getMonth() + clock.getDay()).hashCode());
    }

    public static boolean isCivilian(FleetMemberAPI member) {
        return BaseSkillEffectDescription.isCivilian((FleetMemberAPI)member);
    }

    protected void forceSyncPlayerMemberBuff() {
        UNGP_PlayerFleetMemberBuff.forceSyncNextStep();
    }
}

