/*
 * Decompiled with CFR 0.152.
 */
package ungp.api.backgrounds;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import ungp.api.backgrounds.UNGP_BackgroundPluginAPI;
import ungp.api.saves.UNGP_DataSaverAPI;
import ungp.impl.saves.UNGP_BlueprintsDataSaver;
import ungp.impl.saves.UNGP_CreditsDataSaver;
import ungp.scripts.campaign.inherit.UNGP_InheritData;
import ungp.scripts.utils.Constants;

public abstract class UNGP_BaseBackgroundPlugin
implements UNGP_BackgroundPluginAPI {
    protected Map<Integer, List<BackgroundBonus>> cycleBonusMap = new LinkedHashMap<Integer, List<BackgroundBonus>>();

    public UNGP_BaseBackgroundPlugin() {
        this.initCycleBonus();
    }

    @Override
    public abstract void initCycleBonus();

    protected void addCycleBonus(int cycle, BackgroundBonus bonus) {
        List<BackgroundBonus> bonusList = this.cycleBonusMap.get(cycle);
        if (bonusList == null) {
            bonusList = new LinkedList<BackgroundBonus>();
            this.cycleBonusMap.put(cycle, bonusList);
        }
        bonusList.add(bonus);
    }

    @Override
    public float getInheritCreditsFactor() {
        return 0.0f;
    }

    @Override
    public float getInheritBlueprintsFactor() {
        return 0.0f;
    }

    @Override
    public void addPostDescTooltip(TooltipMakerAPI tooltip, @Nullable UNGP_InheritData pickedInheritData) {
    }

    @Override
    public void addInheritCreditsAndBPsTooltip(TooltipMakerAPI tooltip, @Nullable UNGP_InheritData pickedInheritData) {
        tooltip.addSectionHeading("  " + Constants.backgrounds_i18n.get("heading_basic"), Alignment.LMID, 0.0f);
        tooltip.addSpacer(5.0f);
        float inheritCreditsFactor = this.getInheritCreditsFactor();
        float inheritBlueprintsFactor = this.getInheritBlueprintsFactor();
        float mayInheritCreditsAmount = 0.0f;
        float mayInheritBlueprintsAmount = 0.0f;
        if (pickedInheritData != null) {
            for (UNGP_DataSaverAPI dataSaver : pickedInheritData.dataSavers) {
                if (dataSaver instanceof UNGP_BlueprintsDataSaver) {
                    UNGP_BlueprintsDataSaver blueprintsDataSaver = (UNGP_BlueprintsDataSaver)dataSaver;
                    mayInheritBlueprintsAmount = (int)((float)blueprintsDataSaver.bpAmount * inheritBlueprintsFactor);
                }
                if (!(dataSaver instanceof UNGP_CreditsDataSaver)) continue;
                UNGP_CreditsDataSaver creditsDataSaver = (UNGP_CreditsDataSaver)dataSaver;
                mayInheritCreditsAmount = (int)((float)creditsDataSaver.getCredits() * inheritCreditsFactor);
            }
        }
        Color positiveHighlightColor = Misc.getPositiveHighlightColor();
        Color grayColor = Misc.getGrayColor();
        TooltipMakerAPI imageWithText = tooltip.beginImageWithText("graphics/icons/intel/income_report.png", 24.0f);
        if (mayInheritCreditsAmount > 0.0f) {
            imageWithText.addPara(Constants.root_i18n.get("inheritCredits") + ": %s %s", 0.0f, new Color[]{positiveHighlightColor, grayColor}, new String[]{(int)(inheritCreditsFactor * 100.0f) + "%", "(~" + Misc.getDGSCredits((float)mayInheritCreditsAmount) + ")"});
        } else {
            imageWithText.addPara(Constants.root_i18n.get("inheritCredits") + ": %s %s", 0.0f, new Color[]{positiveHighlightColor, grayColor}, new String[]{(int)(inheritCreditsFactor * 100.0f) + "%", "(-)"});
        }
        tooltip.addImageWithText(0.0f);
        TooltipMakerAPI imageWithText2 = tooltip.beginImageWithText("graphics/icons/intel/fleet_log3.png", 24.0f);
        if (mayInheritBlueprintsAmount > 0.0f) {
            imageWithText2.addPara(Constants.root_i18n.get("inheritBPs") + ": %s %s", 0.0f, new Color[]{positiveHighlightColor, grayColor}, new String[]{(int)(inheritBlueprintsFactor * 100.0f) + "%", "(~" + (int)mayInheritBlueprintsAmount + ")"});
        } else {
            imageWithText2.addPara(Constants.root_i18n.get("inheritBPs") + ": %s %s", 0.0f, new Color[]{positiveHighlightColor, grayColor}, new String[]{(int)(inheritBlueprintsFactor * 100.0f) + "%", "(-)"});
        }
        tooltip.addImageWithText(0.0f);
    }

    @Override
    public Color getOverrideNameColor() {
        return null;
    }

    @Override
    public void addBonusTooltip(TooltipMakerAPI tooltip, @Nullable UNGP_InheritData pickedInheritData, boolean showLimit) {
        if (!this.cycleBonusMap.isEmpty()) {
            tooltip.addSectionHeading("  " + Constants.backgrounds_i18n.get("heading_bonus"), Alignment.LMID, 0.0f);
            tooltip.addSpacer(5.0f);
            Color hl = Misc.getHighlightColor();
            Color gray = Misc.getGrayColor();
            Color base = Misc.getTextColor();
            float pad = 0.0f;
            int curCycle = 1;
            if (pickedInheritData != null) {
                curCycle = pickedInheritData.cycle;
            }
            for (Map.Entry<Integer, List<BackgroundBonus>> entry : this.cycleBonusMap.entrySet()) {
                int cycle = entry.getKey();
                boolean isLimited = false;
                if (curCycle < cycle) {
                    isLimited = true;
                    if (!showLimit) continue;
                }
                boolean isActuallyLocked = isLimited || showLimit;
                Color baseColor = isLimited ? gray : base;
                Color highlightColor = isLimited ? gray : hl;
                for (BackgroundBonus bonus : entry.getValue()) {
                    switch (bonus.type) {
                        case SKILL: {
                            String skillId = (String)bonus.params[0];
                            SkillSpecAPI skillSpec = Global.getSettings().getSkillSpec(skillId);
                            if (skillSpec == null) break;
                            int level = bonus.params[1] instanceof Integer ? (Integer)bonus.params[1] : 1;
                            if (level < 2) {
                                tooltip.addPara(Constants.backgrounds_i18n.get("bonus_skill"), pad, baseColor, highlightColor, new String[]{skillSpec.getName()});
                            } else {
                                tooltip.addPara(Constants.backgrounds_i18n.get("bonus_skill_elite"), pad, baseColor, isLimited ? gray : Misc.getStoryOptionColor(), new String[]{skillSpec.getName()});
                            }
                            if (!isActuallyLocked) break;
                            this.addUnlockCycleStringToTooltipAtRight(tooltip, cycle, gray, pad);
                            break;
                        }
                        case CARGO_STACK: {
                            CargoStackAPI stack = bonus.createCargoStack();
                            tooltip.addPara(Constants.backgrounds_i18n.get("bonus_item"), pad, baseColor, highlightColor, new String[]{stack.getDisplayName(), "" + (int)stack.getSize()});
                            if (!isActuallyLocked) break;
                            this.addUnlockCycleStringToTooltipAtRight(tooltip, cycle, gray, pad);
                            break;
                        }
                        case SHIP: {
                            String variantId = (String)bonus.params[0];
                            int size = bonus.params[1] instanceof Integer ? (Integer)bonus.params[1] : 1;
                            ShipVariantAPI variant = Global.getSettings().getVariant(variantId);
                            ShipHullSpecAPI hullSpec = variant.getHullSpec();
                            tooltip.addPara(Constants.backgrounds_i18n.get("bonus_ship"), pad, baseColor, highlightColor, new String[]{hullSpec.getHullNameWithDashClass(), "" + size});
                            if (!isActuallyLocked) break;
                            this.addUnlockCycleStringToTooltipAtRight(tooltip, cycle, gray, pad);
                            break;
                        }
                        case SKILL_POINTS: {
                            tooltip.addPara(Constants.backgrounds_i18n.get("bonus_skill_point"), pad, baseColor, highlightColor, new String[]{"" + (Integer)bonus.params[0]});
                            if (!isActuallyLocked) break;
                            this.addUnlockCycleStringToTooltipAtRight(tooltip, cycle, gray, pad);
                            break;
                        }
                        case STORY_POINTS: {
                            tooltip.addPara(Constants.backgrounds_i18n.get("bonus_story_point"), pad, baseColor, highlightColor, new String[]{"" + (Integer)bonus.params[0]});
                            if (!isActuallyLocked) break;
                            this.addUnlockCycleStringToTooltipAtRight(tooltip, cycle, gray, pad);
                            break;
                        }
                        case SCRIPT: {
                            BackgroundBonusScript script = (BackgroundBonusScript)bonus.params[0];
                            script.addBonusTooltip(tooltip, pickedInheritData, isLimited, showLimit);
                        }
                    }
                }
                tooltip.addSpacer(0.0f);
            }
        }
    }

    @Override
    public void afterConfirm(UNGP_InheritData pickedInheritData) {
        if (!this.cycleBonusMap.isEmpty()) {
            HashMap<String, Integer> skillGonnaLearnMap = new HashMap<String, Integer>();
            int curCycle = 1;
            if (pickedInheritData != null) {
                curCycle = pickedInheritData.cycle;
            }
            MutableCharacterStatsAPI playerStats = Global.getSector().getPlayerStats();
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            for (Map.Entry<Integer, List<BackgroundBonus>> entry : this.cycleBonusMap.entrySet()) {
                int cycle = entry.getKey();
                if (curCycle < cycle) continue;
                block9: for (BackgroundBonus bonus : entry.getValue()) {
                    switch (bonus.type) {
                        case SKILL: {
                            String skillId = (String)bonus.params[0];
                            int level = bonus.params[1] instanceof Integer ? (Integer)bonus.params[1] : 1;
                            Integer targetLevel = (Integer)skillGonnaLearnMap.get(skillId);
                            if (targetLevel == null) {
                                targetLevel = level;
                            }
                            if (level > targetLevel) {
                                skillGonnaLearnMap.put(skillId, targetLevel);
                            }
                            skillGonnaLearnMap.put(skillId, level);
                            break;
                        }
                        case CARGO_STACK: {
                            CargoStackAPI stack = bonus.createCargoStack();
                            playerFleet.getCargo().addFromStack(stack);
                            break;
                        }
                        case SHIP: {
                            String variantId = (String)bonus.params[0];
                            int size = bonus.params[1] instanceof Integer ? (Integer)bonus.params[1] : 1;
                            ShipVariantAPI variant = Global.getSettings().getVariant(variantId);
                            for (int i = 0; i < size; ++i) {
                                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variant);
                                member.getRepairTracker().setCR(1.0f);
                                playerFleet.getFleetData().addFleetMember(member);
                            }
                            continue block9;
                        }
                        case SKILL_POINTS: {
                            playerStats.addPoints(((Integer)bonus.params[0]).intValue());
                            break;
                        }
                        case STORY_POINTS: {
                            playerStats.addStoryPoints(((Integer)bonus.params[0]).intValue());
                            break;
                        }
                        case SCRIPT: {
                            BackgroundBonusScript script = (BackgroundBonusScript)bonus.params[0];
                            script.afterConfirm(pickedInheritData);
                        }
                    }
                }
            }
            if (!skillGonnaLearnMap.isEmpty()) {
                for (Map.Entry<Integer, List<BackgroundBonus>> entry : skillGonnaLearnMap.entrySet()) {
                    String skillId = (String)((Object)entry.getKey());
                    int level = (Integer)((Object)entry.getValue());
                    int curLevel = (int)playerStats.getSkillLevel(skillId);
                    if (curLevel > 0 && level >= curLevel) {
                        playerStats.addPoints(1);
                        if (curLevel >= 2) {
                            playerStats.addStoryPoints(1);
                        }
                    }
                    if (level <= curLevel) continue;
                    playerStats.setSkillLevel(skillId, (float)level);
                }
            }
        }
    }

    protected String getUnlockCycleString(int cycle) {
        return Constants.backgrounds_i18n.format("bonus_cycle_unlock_tip", "" + cycle);
    }

    protected void addUnlockCycleStringToTooltipAtRight(TooltipMakerAPI tooltip, int cycle, Color gray, float pad) {
        tooltip.addSpacer(-tooltip.getPrev().getPosition().getHeight());
        tooltip.addPara(this.getUnlockCycleString(cycle), gray, pad).setAlignment(Alignment.RMID);
    }

    @Override
    public void addAfterConfirmTooltip(TooltipMakerAPI tooltip, UNGP_InheritData pickedInheritData) {
        this.addBonusTooltip(tooltip, pickedInheritData, false);
    }

    @Override
    public boolean isUnlocked(UNGP_InheritData pickedInheritData) {
        return false;
    }

    protected static class BackgroundBonus {
        protected BackgroundBonusType type;
        protected Object[] params;

        public BackgroundBonus(BackgroundBonusType type, Object ... params) {
            this.type = type;
            this.params = params;
        }

        public CargoStackAPI createCargoStack() {
            CargoStackAPI stack = Global.getFactory().createCargoStack((CargoAPI.CargoItemType)this.params[0], this.params[1], null);
            stack.setSize(Float.parseFloat(this.params[2].toString()));
            return stack;
        }
    }

    protected static enum BackgroundBonusType {
        SKILL,
        CARGO_STACK,
        SHIP,
        SKILL_POINTS,
        STORY_POINTS,
        SCRIPT;

    }

    protected static interface BackgroundBonusScript {
        public void addBonusTooltip(TooltipMakerAPI var1, UNGP_InheritData var2, boolean var3, boolean var4);

        public void afterConfirm(UNGP_InheritData var1);
    }
}

