package ungp.scripts.utils;


public class UNGP_Progress {

   private float elapsed = 0.0F;
   private float targetTime = 1.0F;


   public UNGP_Progress(float targetTime) {
      this.targetTime = targetTime;
   }

   public void advance(float amount) {
      this.elapsed += amount;
   }

   public float getProgress() {
      float progress = this.elapsed / this.targetTime;
      return Math.min(1.0F, progress);
   }

   public void reset() {
      this.elapsed = 0.0F;
   }

   public boolean isDone() {
      return this.elapsed >= this.targetTime;
   }
}
