package ungp.scripts.utils;

import com.fs.starfarer.api.Global;
import java.net.Socket;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.log4j.Logger;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;
import ungp.scripts.utils.Constants;

public class UNGP_Feedback {

   private static final Logger LOGGER = Global.getLogger(UNGP_Feedback.class);
   private static final String FEEDBACK_SENT_KEY = "UNGP_feedbackSent";
   private static final String FEEDBACK_LIST_KEY = "UNGP_feedbackList";


   public static boolean isFeedbackSent() {
      return Global.getSector().getPersistentData().containsKey("UNGP_feedbackSent");
   }

   public static void resetFeedbackSent() {
      Global.getSector().getPersistentData().remove("UNGP_feedbackSent");
   }

   public static void setFeedBackSent() {
      Global.getSector().getPersistentData().put("UNGP_feedbackSent", Boolean.valueOf(true));
   }

   public static void setFeedBackList(List rules) {
      StringBuilder sb = new StringBuilder();
      Iterator var2 = rules.iterator();

      while(var2.hasNext()) {
         URule rule = (URule)var2.next();
         sb.append(rule.getId());
         sb.append("|");
      }

      sb.deleteCharAt(sb.length() - 1);
      Global.getSector().getPersistentData().put("UNGP_feedbackList", sb.toString());
   }

   public static void sendPlayerRulesToServer(List rules) {
      String apiUrl = Constants.rules_i18n.get("button_feedback_url");
      StringBuilder sb = new StringBuilder(apiUrl);
      String ruleString = (String)Global.getSector().getPersistentData().get("UNGP_feedbackList");
      if(ruleString != null) {
         sb.append(ruleString);
      } else {
         if(rules.isEmpty()) {
            return;
         }

         Iterator url = rules.iterator();

         while(url.hasNext()) {
            URule thread = (URule)url.next();
            sb.append(thread.getId());
            sb.append("|");
         }

         sb.deleteCharAt(sb.length() - 1);
      }

      String url1 = sb.toString();
      LOGGER.info(url1);
      Thread var10001 = new Thread;
      url1.<init>(apiUrl);
      Thread thread1 = var10001;
      thread1.setDaemon(true);
      thread1.start();
   }

   public static void setHttpProtocol(HttpsURLConnection conn) {
      SSLContext ctx = MyX509TrustManagerUtils();
      conn.setSSLSocketFactory(ctx.getSocketFactory());
      conn.setHostnameVerifier(new HostnameVerifier() {
         public boolean verify(String s, SSLSession sslSession) {
            return true;
         }
      });
   }

   private static SSLContext MyX509TrustManagerUtils() {
      TrustManager[] tm = new TrustManager[]{new UNGP_Feedback.MyX509TrustManager()};
      SSLContext ctx = null;

      try {
         ctx = SSLContext.getInstance("TLSv1.2");
         ctx.init((KeyManager[])null, tm, (SecureRandom)null);
      } catch (Exception var3) {
         var3.printStackTrace();
      }

      return ctx;
   }

   // $FF: synthetic method
   private static void lambda$sendPlayerRulesToServer$0(String url, String apiUrl) {
      try {
         URL e = new URL(url);
         HttpsURLConnection conn = (HttpsURLConnection)e.openConnection();
         setHttpProtocol(conn);
         conn.getInputStream().close();
         LOGGER.info(url);
      } catch (Exception var4) {
         LOGGER.info(apiUrl);
         LOGGER.info(var4);
      }

   }


   private static class MyX509TrustManager extends X509ExtendedTrustManager {

      public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
      }

      public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
      }

      public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
      }

      public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
      }

      public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
      }

      public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
      }

      public X509Certificate[] getAcceptedIssuers() {
         return new X509Certificate[0];
      }
   }
}
