package ungp.scripts.ui;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.lazywizard.lazylib.ui.FontException;
import org.lazywizard.lazylib.ui.LazyFont;
import org.lazywizard.lazylib.ui.LazyFont.DrawableString;

public class UNGPFont {

   public static DrawableString ORBITRON;
   public static DrawableString ORBITRON_BOLD;
   private static LazyFont orbitronMod;
   private static LazyFont orbitronCore;
   private static final Map DYNAMIC_DRAWABLE_MAP = new HashMap();
   private static final Pattern ENG_CHECKER = Pattern.compile("^[\\sa-zA-Z]*");


   public static boolean notOnlyEN(String s) {
      return ENG_CHECKER.matcher(s).matches();
   }

   public static void init() {
      try {
         orbitronMod = LazyFont.loadFont("graphics/ungp/fonts/ungp_orbitron.fnt");
         orbitronCore = LazyFont.loadFont("graphics/fonts/orbitron20aabold.fnt");
         ORBITRON = orbitronMod.createText();
         ORBITRON_BOLD = orbitronCore.createText();
      } catch (FontException var1) {
         throw new RuntimeException("Error font loading...");
      }
   }

   public static DrawableString getDynamicDrawable(String content, Color color) {
      String key = color.toString();
      DrawableString drawableString = (DrawableString)DYNAMIC_DRAWABLE_MAP.get(key);
      if(drawableString == null) {
         drawableString = orbitronMod.createText(content, color, 20.0F, 32.0F, 32.0F);
         DYNAMIC_DRAWABLE_MAP.put(key, drawableString);
      }

      return drawableString;
   }

   public static void clearDynamicDrawable() {
      Collection drawableStrings = DYNAMIC_DRAWABLE_MAP.values();
      Iterator var1 = drawableStrings.iterator();

      while(var1.hasNext()) {
         DrawableString drawableString = (DrawableString)var1.next();
         drawableString.dispose();
      }

      DYNAMIC_DRAWABLE_MAP.clear();
   }

   public static LazyFont getOrbitronMod() {
      return orbitronMod;
   }

   public static void drawShadow(DrawableString drawableString, float cx, float cy, float offset) {
      drawableString.draw(cx - offset, cy);
      drawableString.draw(cx + offset, cy);
      drawableString.draw(cx, cy - offset);
      drawableString.draw(cx, cy + offset);
   }

}
