package ungp.scripts.ui;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.opengl.GL11;
import ungp.scripts.campaign.everyframe.UNGP_UITimeScript;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;

public class RuleDescBackgroundPlugin extends BaseCustomUIPanelPlugin {

   private PositionAPI position;
   private URule rule;
   private boolean isCodex;


   public RuleDescBackgroundPlugin(PositionAPI position, URule rule) {
      this(position, rule, false);
   }

   public RuleDescBackgroundPlugin(PositionAPI position, URule rule, boolean isCodex) {
      this.position = position;
      this.rule = rule;
      this.isCodex = isCodex;
   }

   public void renderBelow(float alphaMult) {
      GL11.glPushMatrix();
      GL11.glDisable(3553);
      GL11.glEnable(3042);
      GL11.glBlendFunc(770, 771);
      float frameFactor = UNGP_UITimeScript.getFactor("6secs");
      float x = this.position.getX();
      float width = this.position.getWidth();
      float y = this.position.getY();
      float height = this.position.getHeight();
      Misc.renderQuad(x, y, width, height, this.rule.getCorrectColor(), (float)Math.sin(3.141592653589793D * (double)frameFactor) * 0.06F + 0.04F);
      GL11.glEnable(3553);
      if(!this.isCodex) {
         Difficulty sprite = UNGP_RulesManager.getGlobalDifficulty();
         if(sprite != null) {
            SpriteAPI size = Global.getSettings().getSprite(sprite.spritePath);
            float size1 = 80.0F;
            size.setWidth(size1);
            size.setHeight(size1);
            size.setAlphaMult(0.2F);
            size.render(x + width - size1, y + height - size1);
         }
      } else {
         SpriteAPI sprite1 = Global.getSettings().getSprite(this.rule.getSpritePath());
         float size2 = 80.0F;
         sprite1.setWidth(size2);
         sprite1.setHeight(size2);
         sprite1.setAlphaMult(0.8F);
         sprite1.render(x + width - size2, y + height - size2);
      }

      GL11.glPopMatrix();
   }

   public static void addToTooltip(TooltipMakerAPI tooltip, URule rule, boolean isCodex) {
      RuleDescBackgroundPlugin instance = new RuleDescBackgroundPlugin(tooltip.getPosition(), rule, isCodex);
      CustomPanelAPI custom = Global.getSettings().createCustom(0.0F, 0.0F, instance);
      tooltip.addCustom(custom, 0.0F);
   }
}
