package ungp.scripts.ui;

import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HorizontalButtonGroup {

   protected List buttons;


   public HorizontalButtonGroup() {
      this.buttons = new ArrayList();
   }

   public HorizontalButtonGroup(ButtonAPI ... buttons) {
      this.buttons = Arrays.asList(buttons);
   }

   public void addButton(ButtonAPI button) {
      this.buttons.add(button);
   }

   public void updateTooltip(TooltipMakerAPI tooltip, float buttonPad) {
      for(int i = 1; i < this.buttons.size(); ++i) {
         ButtonAPI button = (ButtonAPI)this.buttons.get(i);
         ButtonAPI prevButton = (ButtonAPI)this.buttons.get(i - 1);
         button.getPosition().rightOfBottom(prevButton, buttonPad);
      }

      tooltip.addSpacer(0.0F);
      tooltip.getPrev().getPosition().belowLeft((UIComponentAPI)this.buttons.get(0), 0.0F);
   }
}
