package ungp.scripts.ui;

import com.fs.starfarer.api.ui.ButtonAPI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

public class CheckBoxGroup {

   private Map checkBoxMap = new HashMap();
   private ButtonAPI lastCheckedButton;


   public void addCheckBox(ButtonAPI checkBox, Object data) {
      this.checkBoxMap.put(checkBox, data);
   }

   public void clear() {
      this.checkBoxMap.clear();
   }

   public ButtonAPI getCheckedButton() {
      return this.lastCheckedButton;
   }

   public Object getCheckedValue() {
      return this.checkBoxMap.get(this.lastCheckedButton);
   }

   public void tryCheckValue(Object value) {
      Iterator var2 = this.checkBoxMap.entrySet().iterator();

      while(var2.hasNext()) {
         Entry entry = (Entry)var2.next();
         Object entryValue = entry.getValue();
         if(entryValue == null) {
            if(value == null) {
               ((ButtonAPI)entry.getKey()).setChecked(true);
               break;
            }
         } else if(entryValue.equals(value)) {
            ((ButtonAPI)entry.getKey()).setChecked(true);
            break;
         }
      }

   }

   public void updateCheck() {
      Set checkBoxes = this.checkBoxMap.keySet();
      Iterator targetButton;
      ButtonAPI checkBox;
      if(this.lastCheckedButton == null) {
         boolean count = false;
         targetButton = checkBoxes.iterator();

         while(targetButton.hasNext()) {
            checkBox = (ButtonAPI)targetButton.next();
            if(!count && checkBox.isChecked()) {
               this.lastCheckedButton = checkBox;
               count = true;
            } else {
               checkBox.setChecked(false);
            }
         }
      }

      int var6 = 0;
      targetButton = checkBoxes.iterator();

      while(targetButton.hasNext()) {
         checkBox = (ButtonAPI)targetButton.next();
         if(checkBox.isChecked()) {
            ++var6;
         }
      }

      if(var6 >= 2) {
         ButtonAPI var7 = null;
         Iterator var8 = checkBoxes.iterator();

         while(var8.hasNext()) {
            ButtonAPI checkBox1 = (ButtonAPI)var8.next();
            if(checkBox1.isChecked()) {
               if(checkBox1 != this.lastCheckedButton) {
                  var7 = checkBox1;
               }

               checkBox1.setChecked(false);
            }
         }

         if(var7 != null) {
            this.lastCheckedButton = var7;
         }
      }

      if(this.lastCheckedButton != null) {
         this.lastCheckedButton.setChecked(true);
      }

   }
}
