package ungp.scripts.plugins;

import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ungp.api.rules.UNGP_RuleEffectAPI;
import ungp.api.rules.tags.UNGP_CombatInitTag;
import ungp.api.rules.tags.UNGP_CombatTag;
import ungp.api.rules.tags.UNGP_TweakBeforeApplyCombatTag;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;
import ungp.scripts.utils.Constants;
import ungp.scripts.utils.UNGPUtils;

public class UNGP_SpecialistCombatPlugin extends BaseEveryFrameCombatPlugin {

   private CombatEngineAPI engine;
   private boolean init = false;
   private boolean isSpecialistMode = false;
   private List tags = new ArrayList();
   private List bonusMessages = new ArrayList();
   private List notBonusMessages = new ArrayList();


   public void init(CombatEngineAPI engine) {
      this.engine = engine;
      if(engine.isInCampaign() || engine.isInCampaignSim()) {
         UNGP_InGameData inGameData = UNGP_InGameData.getDataInSave();
         if(inGameData != null && inGameData.isHardMode()) {
            if(engine.isInCampaignSim() && !UNGP_SpecialistSettings.isRulesEnabledInSimulation()) {
               return;
            }

            this.isSpecialistMode = true;
            Difficulty difficulty = inGameData.getDifficulty();
            ArrayList originalRules = new ArrayList(UNGP_RulesManager.COMBAT_RULES_IN_THIS_GAME);
            ArrayList activatedRules = new ArrayList(originalRules);
            Iterator var6 = originalRules.iterator();

            URule rule;
            while(var6.hasNext()) {
               rule = (URule)var6.next();
               if(rule.getRuleEffect() instanceof UNGP_TweakBeforeApplyCombatTag) {
                  ((UNGP_TweakBeforeApplyCombatTag)rule.getRuleEffect()).tweakBeforeApply(activatedRules, originalRules);
               }
            }

            var6 = activatedRules.iterator();

            while(var6.hasNext()) {
               rule = (URule)var6.next();
               UNGP_RuleEffectAPI ruleEffect = rule.getRuleEffect();
               boolean addMessage = false;
               if(ruleEffect instanceof UNGP_CombatTag) {
                  this.tags.add((UNGP_CombatTag)ruleEffect);
                  addMessage = true;
               }

               if(ruleEffect instanceof UNGP_CombatInitTag) {
                  ((UNGP_CombatInitTag)ruleEffect).init(engine);
                  addMessage = true;
               }

               if(addMessage) {
                  if(rule.isPositive()) {
                     this.bonusMessages.add(rule.generateCombatTips(difficulty));
                  } else {
                     this.notBonusMessages.add(rule.generateCombatTips(difficulty));
                  }
               }
            }
         }
      }

   }

   public void advance(float amount, List events) {
      Iterator ships;
      if(!this.init) {
         this.init = true;
         if(this.isSpecialistMode) {
            if(!UNGP_Settings.isNoRuleMessageWhileBattleStart()) {
               ships = this.bonusMessages.iterator();

               Object[] tag;
               while(ships.hasNext()) {
                  tag = (Object[])ships.next();
                  this.engine.getCombatUI().addMessage(0, tag);
               }

               ships = this.notBonusMessages.iterator();

               while(ships.hasNext()) {
                  tag = (Object[])ships.next();
                  this.engine.getCombatUI().addMessage(0, tag);
               }

               this.engine.getCombatUI().addMessage(0, new Object[]{Misc.getHighlightColor(), Constants.root_i18n.get("specialist_mode_combat_loading")});
            }

            this.bonusMessages.clear();
            this.notBonusMessages.clear();
         }
      }

      if(this.isSpecialistMode) {
         if(this.engine.isPaused()) {
            amount = 0.0F;
         }

         ships = this.tags.iterator();

         while(ships.hasNext()) {
            UNGP_CombatTag tag2 = (UNGP_CombatTag)ships.next();
            tag2.advanceInCombat(this.engine, amount);
         }

         List ships1 = this.engine.getShips();
         Iterator tag3 = ships1.iterator();

         while(tag3.hasNext()) {
            ShipAPI ship = (ShipAPI)tag3.next();
            if(ship.isAlive()) {
               Iterator var6;
               UNGP_CombatTag tag1;
               if(UNGPUtils.isPlayerShip(ship)) {
                  var6 = this.tags.iterator();

                  while(var6.hasNext()) {
                     tag1 = (UNGP_CombatTag)var6.next();
                     tag1.applyPlayerShipInCombat(amount, this.engine, ship);
                  }
               } else {
                  var6 = this.tags.iterator();

                  while(var6.hasNext()) {
                     tag1 = (UNGP_CombatTag)var6.next();
                     tag1.applyEnemyShipInCombat(amount, ship);
                  }
               }
            }
         }

      }
   }
}
