package ungp.scripts.campaign.ui;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.CustomVisualDialogDelegate.DialogCallbacks;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.CutStyle;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.ui.ButtonAPI.UICheckboxSize;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.lwjgl.opengl.GL11;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeProgress;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistBackgroundUI;
import ungp.scripts.campaign.specialist.rules.UNGP_RulePickHelper;
import ungp.scripts.campaign.specialist.rules.UNGP_RulePickPresetManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulePickHelper.UnmetReason;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.UNGP_RuleSorter;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;
import ungp.scripts.campaign.ui.UNGP_RulePickItemPanelPlugin;
import ungp.scripts.ui.CheckBoxGroup;
import ungp.scripts.ui.UIRect;
import ungp.scripts.utils.Constants;

public class UNGP_RulePickPanelPlugin extends BaseCustomUIPanelPlugin {

   private static final Logger LOGGER = Global.getLogger(UNGP_RulePickPanelPlugin.class);
   protected CustomPanelAPI panel;
   protected InteractionDialogAPI dialog;
   protected DialogCallbacks callbacks;
   private PositionAPI pos;
   private List allRuleButtons = new ArrayList();
   private CheckBoxGroup presetCheckboxGroup = new CheckBoxGroup();
   private ButtonAPI presetSaveBtn;
   private ButtonAPI presetLoadBtn;
   private ButtonAPI confirmBtn;
   private ButtonAPI cancelBtn;
   private Difficulty difficulty;
   private List pickedRules;
   private List completedChallenges;
   private LabelAPI positiveRuleCount;
   private LabelAPI negativeRuleCount;
   private LabelAPI l_curCost;
   private LabelAPI l_curRuleCount;
   private UIRect positiveRuleSummaryContentSect;
   private UIRect negativeRuleSummaryContentSect;
   private UIRect challengeContentSect;
   private UIRect reasonUnmetSect;
   private Script onConfirm;
   private Script onCancel;
   private boolean isRuleInit = false;


   public UNGP_RulePickPanelPlugin(Difficulty difficulty, List pickedRules, List completedChallenges, Script onConfirm, Script onCancel) {
      this.difficulty = difficulty;
      this.pickedRules = pickedRules;
      this.completedChallenges = completedChallenges;
      this.onConfirm = onConfirm;
      this.onCancel = onCancel;
   }

   public static UNGP_RulePickPanelPlugin createPlugin(Difficulty difficulty, List previousSelectedRules, List completedChallenges, Script onConfirm, Script onCancel) {
      return new UNGP_RulePickPanelPlugin(difficulty, previousSelectedRules, completedChallenges, onConfirm, onCancel);
   }

   public void init(CustomPanelAPI panel, DialogCallbacks callbacks, InteractionDialogAPI dialog) {
      this.panel = panel;
      this.callbacks = callbacks;
      this.dialog = dialog;
      UNGP_ChallengeManager.setTemporaryCompletedChallenges(this.completedChallenges);
      this.createContent();
      CustomPanelAPI customPanel = panel.createCustomPanel(this.pos.getWidth(), this.pos.getHeight(), new UNGP_SpecialistBackgroundUI(0.8F));
      UNGP_SpecialistBackgroundUI.stopTicking();
      panel.addComponent(customPanel);
      Global.getSoundPlayer().playCustomMusic(1, 1, "UNGP_rulepicker_bgm", true);
   }

   protected void createContent() {
      float panelWidth = this.pos.getWidth();
      float panelHeight = this.pos.getHeight();
      Color boarderColor = Misc.getDarkPlayerColor();
      float sectionHeadingHeight = 25.0F;
      List allRulesCopy = UNGP_RulesManager.getAvailableRules(this.completedChallenges);
      ArrayList positiveRules = new ArrayList();
      ArrayList negativeRules = new ArrayList();
      Iterator temp = allRulesCopy.iterator();

      while(temp.hasNext()) {
         URule parentPanelRect = (URule)temp.next();
         if(parentPanelRect.isPositive()) {
            positiveRules.add(parentPanelRect);
         } else {
            negativeRules.add(parentPanelRect);
         }
      }

      positiveRules.sort(new UNGP_RuleSorter());
      negativeRules.sort(new UNGP_RuleSorter());
      UIRect var53 = new UIRect(0.0F, 0.0F, panelWidth, panelHeight);
      UIRect shrinkPanelRect = var53.shrink(20.0F);
      UIRect[] var52 = shrinkPanelRect.splitHorizontallyReverse(512.0F);
      UIRect ruleRect = var52[0];
      UIRect readMeAndDetailsRect = var52[1];
      var52 = ruleRect.splitVertically(new float[]{0.46F, 0.46F, 0.08F});
      UIRect positiveRuleRect = var52[0].shrink(5.0F);
      UIRect negativeRuleRect = var52[1].shrink(5.0F);
      UIRect presetRect = var52[2].shrink(5.0F);
      this.createRuleRect(ruleRect, positiveRuleRect, positiveRules, negativeRuleRect, negativeRules);
      presetRect.addBoarder(this.panel, boarderColor, 2.0F);
      var52 = presetRect.shrink(10.0F).splitHorizontally(new float[]{1.0F, 1.0F, 1.0F, 1.0F, 1.0F, 1.0F});

      UIRect presetSaveRect;
      for(presetSaveRect = 0; presetSaveRect < 4; ++presetSaveRect) {
         UIRect presetSaveTooltip = var52[presetSaveRect];
         TooltipMakerAPI presetLoadRect = presetSaveTooltip.beginTooltip(this.panel, false);
         ButtonAPI readMeSect = presetSaveTooltip.getWidth().addCheckbox(presetSaveTooltip.getHeight(), (float)Constants.rules_i18n.get("rule_preset_prefix"), presetSaveRect + 1, presetSaveRect, UICheckboxSize.SMALL, 0.0F);
         if(presetSaveRect == false) {
            readMeSect.setChecked(true);
         }

         this.presetCheckboxGroup.addCheckBox(readMeSect, presetSaveRect);
         presetSaveTooltip.addTooltip();
      }

      presetSaveRect = var52[4].shrink(10.0F);
      TooltipMakerAPI var54 = presetSaveRect.beginTooltip(this.panel, false);
      this.presetSaveBtn = var54.addButton(Constants.rules_i18n.get("rule_preset_button_save"), "preset_save", presetSaveRect.getWidth(), presetSaveRect.getHeight(), 0.0F);
      presetSaveRect.addTooltip();
      UIRect var55 = var52[5].shrink(10.0F);
      TooltipMakerAPI presetLoadTooltip = var55.beginTooltip(this.panel, false);
      this.presetLoadBtn = presetLoadTooltip.addButton(Constants.rules_i18n.get("rule_preset_button_load"), "preset_load", var55.getWidth(), var55.getHeight(), 0.0F);
      var55.addTooltip();
      var52 = readMeAndDetailsRect.splitVertically(new float[]{0.35F, 0.5F, 0.15F});
      UIRect var56 = var52[0].shrink(10.0F);
      UIRect detailSect = var52[1];
      UIRect confirmSect = var52[2];
      var56.addBoarder(this.panel, boarderColor, 2.0F);
      var56 = var56.shrink(10.0F);
      TooltipMakerAPI readMeTooltip = var56.beginTooltip(this.panel, true);
      TooltipMakerAPI imageTooltip = readMeTooltip.beginImageWithText(this.difficulty.spritePath, 64.0F);
      imageTooltip.setParaOrbitronLarge();
      if(this.difficulty == Difficulty.OMEGA) {
         imageTooltip.addPara(Constants.root_i18n.get("rulepick_level"), 0.0F, Misc.getNegativeHighlightColor(), this.difficulty.color, new String[]{this.difficulty.name});
      } else {
         imageTooltip.addPara(Constants.root_i18n.get("rulepick_level"), 0.0F, this.difficulty.color, new String[]{this.difficulty.name});
      }

      imageTooltip.setParaFontDefault();
      imageTooltip.setBulletedListMode("  - ");
      imageTooltip.addPara(Constants.rules_i18n.get("pick_rule_min_rule_count"), 10.0F, Misc.getBasePlayerColor(), Misc.getHighlightColor(), new String[]{this.difficulty.minRules});
      imageTooltip.addPara(Constants.rules_i18n.get("pick_rule_max_rule_count"), 0.0F, Misc.getBasePlayerColor(), Misc.getHighlightColor(), new String[]{this.difficulty.maxRules});
      imageTooltip.setBulletedListMode((String)null);
      readMeTooltip.addImageWithText(0.0F);
      readMeTooltip.setParaOrbitronVeryLarge();
      readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic"), Misc.getBasePlayerColor(), 10.0F);
      readMeTooltip.setParaOrbitronLarge();
      readMeTooltip.setBulletedListMode("  - ");
      readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic1"), 10.0F, UNGP_RulesManager.getPNColor(true), new String[]{UNGP_RulesManager.getPNRuleString(true)});
      readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic2"), 0.0F, UNGP_RulesManager.getPNColor(false), new String[]{UNGP_RulesManager.getPNRuleString(false)});
      readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic3"), 0.0F, UNGP_RulesManager.getGoldenColor(), new String[]{UNGP_RulesManager.getGoldenRuleString()});
      readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic4"), 0.0F, UNGP_RulesManager.getMilestoneColor(), new String[]{UNGP_RulesManager.getRuleTypeName(true, false, true), Constants.rules_i18n.get("challenge_name")});
      readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_basic5"), 0.0F, Misc.getHighlightColor(), new String[]{"0"});
      readMeTooltip.setBulletedListMode((String)null);
      readMeTooltip.setParaOrbitronVeryLarge();
      readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_challenge"), Misc.getBasePlayerColor(), 10.0F);
      readMeTooltip.setParaOrbitronLarge();
      readMeTooltip.setBulletedListMode("  - ");
      readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_challenge1"), 10.0F);
      readMeTooltip.addPara(Constants.rules_i18n.get("pick_rule_challenge2"), 0.0F, Difficulty.ALPHA.color, new String[]{Difficulty.ALPHA.name});
      readMeTooltip.setBulletedListMode((String)null);
      var56.addTooltip();
      var52 = detailSect.splitVerticallyReverse(100.0F);
      UIRect ruleSummaryRect = var52[0].shrink(10.0F);
      UIRect ruleConditionSect = var52[1].shrink(0.0F, 0.0F, 10.0F, 10.0F);
      ruleSummaryRect.addBoarder(this.panel, boarderColor, 2.0F);
      var52 = ruleSummaryRect.splitVertically(new float[]{0.6F, 0.4F});
      UIRect pnRulesSect = var52[0];
      UIRect challengeSect = var52[1];
      var52 = pnRulesSect.splitHorizontally(new float[]{0.5F, 0.5F});
      UIRect positiveRuleSummarySect = var52[0];
      UIRect negativeRuleSummarySect = var52[1];
      var52 = positiveRuleSummarySect.splitVertically(sectionHeadingHeight);
      UIRect positiveRuleSummaryHeadingSect = var52[0];
      this.positiveRuleSummaryContentSect = var52[1].shrink(2.0F, 0.0F);
      TooltipMakerAPI positiveRuleSummaryHeadingTooltip = positiveRuleSummaryHeadingSect.beginTooltip(this.panel, false);
      positiveRuleSummaryHeadingSect.syncPositionSize(positiveRuleSummaryHeadingTooltip.addSectionHeading(UNGP_RulesManager.getPNRuleString(true), UNGP_RulesManager.getPNColor(true), boarderColor, Alignment.MID, 0.0F).getPosition());
      positiveRuleSummaryHeadingSect.addTooltip();
      var52 = negativeRuleSummarySect.splitVertically(sectionHeadingHeight);
      UIRect negativeRuleSummaryHeadingSect = var52[0];
      this.negativeRuleSummaryContentSect = var52[1].shrink(2.0F, 0.0F);
      TooltipMakerAPI negativeRuleSummaryHeadingTooltip = negativeRuleSummaryHeadingSect.beginTooltip(this.panel, false);
      negativeRuleSummaryHeadingSect.syncPositionSize(negativeRuleSummaryHeadingTooltip.addSectionHeading(UNGP_RulesManager.getPNRuleString(false), UNGP_RulesManager.getPNColor(false), boarderColor, Alignment.MID, 0.0F).getPosition());
      negativeRuleSummaryHeadingSect.addTooltip();
      var52 = challengeSect.splitVertically(sectionHeadingHeight);
      UIRect challengeHeadingSect = var52[0];
      this.challengeContentSect = var52[1].shrink(2.0F, 0.0F);
      TooltipMakerAPI challengeHeadingTooltip = challengeHeadingSect.beginTooltip(this.panel, false);
      challengeHeadingSect.syncPositionSize(challengeHeadingTooltip.addSectionHeading(Constants.rules_i18n.get("challenge_name"), UNGP_RulesManager.getMilestoneColor(), boarderColor, Alignment.MID, 0.0F).getPosition());
      challengeHeadingSect.addTooltip();
      ruleConditionSect.addBoarder(this.panel, boarderColor, 2.0F);
      var52 = ruleConditionSect.splitVertically(sectionHeadingHeight);
      UIRect ruleConditionHeadingSect = var52[0];
      TooltipMakerAPI ruleConditionHeadingTooltip = ruleConditionHeadingSect.beginTooltip(this.panel, false);
      ruleConditionHeadingSect.syncPositionSize(ruleConditionHeadingTooltip.addSectionHeading(Constants.rules_i18n.get("pick_rule_condition_heading"), Alignment.MID, 0.0F).getPosition());
      ruleConditionHeadingSect.addTooltip();
      UIRect ruleConditionContentSect = var52[1].shrink(10.0F);
      TooltipMakerAPI ruleConditionTooltip = ruleConditionContentSect.beginTooltip(this.panel, false);
      ruleConditionTooltip.setParaOrbitronLarge();
      this.l_curCost = ruleConditionTooltip.addPara("", Misc.getBasePlayerColor(), 5.0F);
      this.l_curRuleCount = ruleConditionTooltip.addPara("", Misc.getBasePlayerColor(), 5.0F);
      ruleConditionTooltip.setParaFontDefault();
      ruleConditionContentSect.addTooltip();
      var52 = confirmSect.splitHorizontally(new float[]{0.6F, 0.4F});
      UIRect reasonSect = var52[0].shrink(10.0F);
      UIRect okOrNotSect = var52[1].shrink(10.0F);
      reasonSect.addBoarder(this.panel, boarderColor, 2.0F);
      var52 = reasonSect.splitVertically(sectionHeadingHeight);
      UIRect reasonUnmetHeading = var52[0];
      TooltipMakerAPI reasonUnmetHeadingTooltip = reasonUnmetHeading.beginTooltip(this.panel, false);
      reasonUnmetHeading.syncPositionSize(reasonUnmetHeadingTooltip.addSectionHeading(Constants.rules_i18n.get("unmet_heading"), Alignment.MID, 0.0F).getPosition());
      reasonUnmetHeading.addTooltip();
      this.reasonUnmetSect = var52[1].shrink(10.0F);
      var52 = okOrNotSect.splitVertically(new float[]{0.5F, 0.5F});
      UIRect confirmBtnSect = var52[0].shrink(0.0F, 5.0F);
      TooltipMakerAPI confirmBtnTooltip = confirmBtnSect.beginTooltip(this.panel, false);
      confirmBtnTooltip.setButtonFontOrbitron20Bold();
      this.confirmBtn = confirmBtnTooltip.addButton(Constants.rules_i18n.get("pick_rule_confirm"), "confirm", confirmBtnSect.getWidth(), confirmBtnSect.getHeight(), 0.0F);
      confirmBtnSect.addTooltip();
      UIRect cancelBtnSect = var52[1].shrink(0.0F, 5.0F);
      TooltipMakerAPI cancelBtnTooltip = cancelBtnSect.beginTooltip(this.panel, false);
      cancelBtnTooltip.setButtonFontOrbitron20Bold();
      this.cancelBtn = cancelBtnTooltip.addButton(Constants.rules_i18n.get("pick_rule_cancel"), "cancel", cancelBtnSect.getWidth(), cancelBtnSect.getHeight(), 0.0F);
      this.cancelBtn.setShortcut(1, true);
      cancelBtnSect.addTooltip();
      if(!this.isRuleInit) {
         this.isRuleInit = true;
         Iterator var49 = this.allRuleButtons.iterator();

         while(var49.hasNext()) {
            ButtonAPI ruleButton = (ButtonAPI)var49.next();
            URule rule = (URule)ruleButton.getCustomData();
            if(this.pickedRules.contains(rule)) {
               ruleButton.setChecked(true);
            }
         }
      }

      this.triggerPresetEvents((Object)null);
      this.updateRuleThings();
   }

   private void createRuleRect(UIRect ruleRect, UIRect positiveRuleRect, List positiveRules, UIRect negativeRuleRect, List negativeRules) {
      float rulePadding = 10.0F;
      float ruleYPadding = rulePadding * 2.5F;
      int itemPerRow = (int)(ruleRect.getWidth() / (112.0F + rulePadding));
      UIRect[] temp = positiveRuleRect.splitVertically(32.0F);
      UIRect positiveRuleTitleRect = temp[0];
      UIRect positiveRuleContentRect = temp[1];
      TooltipMakerAPI positiveRuleTitleTooltip = positiveRuleTitleRect.beginTooltip(this.panel, false);
      TooltipMakerAPI positiveRuleTitleImageTooltip = positiveRuleTitleTooltip.beginImageWithText(UNGP_RulesManager.getRuleIconSpriteName(false, false, true), 16.0F);
      positiveRuleTitleImageTooltip.setParaOrbitronLarge();
      positiveRuleTitleImageTooltip.addPara(UNGP_RulesManager.getPNRuleString(true), UNGP_RulesManager.getPNColor(true), 0.0F);
      positiveRuleTitleTooltip.addImageWithText(0.0F);
      this.positiveRuleCount = positiveRuleTitleTooltip.createLabel("", Color.white);
      this.positiveRuleCount.setAlignment(Alignment.RMID);
      PositionAPI positiveRuleCountPos = positiveRuleTitleTooltip.addCustomDoNotSetPosition((UIComponentAPI)this.positiveRuleCount).getPosition();
      positiveRuleCountPos.setSize(positiveRuleTitleRect.getWidth() - 110.0F, positiveRuleTitleRect.getHeight());
      positiveRuleCountPos.inTL(0.0F, 0.0F);
      positiveRuleTitleTooltip.addButton(Constants.rules_i18n.get("pick_rule_clear"), "clear_positive_rules", Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Alignment.MID, CutStyle.BL_TR, 100.0F, positiveRuleTitleRect.getHeight() * 0.8F, 0.0F).getPosition().inTL(positiveRuleTitleRect.getWidth() - 100.0F, 0.0F);
      positiveRuleTitleRect.addTooltip();
      TooltipMakerAPI positiveRuleContentTooltip = positiveRuleContentRect.beginTooltip(this.panel, true);

      for(int negativeRuleTitleRect = 0; negativeRuleTitleRect < positiveRules.size(); ++negativeRuleTitleRect) {
         URule negativeRuleContentRect = (URule)positiveRules.get(negativeRuleTitleRect);
         UNGP_RulePickItemPanelPlugin negativeRuleTitleTooltip = new UNGP_RulePickItemPanelPlugin(negativeRuleContentRect, new UNGP_RulePickItemPanelPlugin.ButtonPressListener() {
            public void notifyPressed(ButtonAPI button) {
               UNGP_RulePickPanelPlugin.LOGGER.info(button.getCustomData());
               UNGP_RulePickPanelPlugin.this.buttonPressed((ButtonAPI)button);
            }
         });
         CustomPanelAPI negativeRuleTitleImageTooltip = Global.getSettings().createCustom(112.0F, 112.0F, negativeRuleTitleTooltip);
         negativeRuleTitleTooltip.init(negativeRuleTitleImageTooltip);
         int negativeRuleCountPos = negativeRuleTitleRect % itemPerRow;
         int negativeRuleContentTooltip = negativeRuleTitleRect / itemPerRow;
         float i = (float)negativeRuleCountPos * 112.0F + (float)negativeRuleCountPos * rulePadding;
         float curRule = (float)negativeRuleContentTooltip * 112.0F + (float)negativeRuleContentTooltip * ruleYPadding;
         positiveRuleContentTooltip.addCustomDoNotSetPosition(negativeRuleTitleImageTooltip).getPosition().inTL(i, curRule);
         positiveRuleContentTooltip.addSpacer(1.0F / (float)itemPerRow * (112.0F + ruleYPadding));
         this.allRuleButtons.add(negativeRuleTitleTooltip.getLinkedButton());
      }

      positiveRuleContentTooltip.addSpacer(112.0F);
      positiveRuleContentRect.addTooltip();
      temp = negativeRuleRect.splitVertically(32.0F);
      UIRect var30 = temp[0];
      UIRect var31 = temp[1];
      TooltipMakerAPI var32 = var30.beginTooltip(this.panel, false);
      TooltipMakerAPI var33 = var32.beginImageWithText(UNGP_RulesManager.getRuleIconSpriteName(false, false, false), 16.0F);
      var33.setParaOrbitronLarge();
      var33.addPara(UNGP_RulesManager.getPNRuleString(false), UNGP_RulesManager.getPNColor(false), 0.0F);
      var32.addImageWithText(0.0F);
      this.negativeRuleCount = var32.createLabel("", Color.white);
      this.negativeRuleCount.setAlignment(Alignment.RMID);
      PositionAPI var34 = var32.addCustomDoNotSetPosition((UIComponentAPI)this.negativeRuleCount).getPosition();
      var34.setSize(var30.getWidth() - 110.0F, var30.getHeight());
      var34.inTL(0.0F, 0.0F);
      var32.addButton(Constants.rules_i18n.get("pick_rule_clear"), "clear_negative_rules", Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Alignment.MID, CutStyle.BL_TR, 100.0F, var30.getHeight() * 0.8F, 0.0F).getPosition().inTL(var30.getWidth() - 100.0F, 0.0F);
      var30.addTooltip();
      TooltipMakerAPI var35 = var31.beginTooltip(this.panel, true);

      for(int var36 = 0; var36 < negativeRules.size(); ++var36) {
         URule var37 = (URule)negativeRules.get(var36);
         UNGP_RulePickItemPanelPlugin plugin = new UNGP_RulePickItemPanelPlugin(var37, new UNGP_RulePickItemPanelPlugin.ButtonPressListener() {
            public void notifyPressed(ButtonAPI button) {
               UNGP_RulePickPanelPlugin.this.buttonPressed((ButtonAPI)button);
            }
         });
         CustomPanelAPI custom = Global.getSettings().createCustom(112.0F, 112.0F, plugin);
         plugin.init(custom);
         int x_index = var36 % itemPerRow;
         int y_index = var36 / itemPerRow;
         float itemX = (float)x_index * 112.0F + (float)x_index * rulePadding;
         float itemY = (float)y_index * 112.0F + (float)y_index * ruleYPadding;
         var35.addCustomDoNotSetPosition(custom).getPosition().inTL(itemX, itemY);
         var35.addSpacer(1.0F / (float)itemPerRow * (112.0F + ruleYPadding));
         this.allRuleButtons.add(plugin.getLinkedButton());
      }

      var35.addSpacer(112.0F);
      var31.addTooltip();
   }

   public void positionChanged(PositionAPI position) {
      this.pos = position;
   }

   public void renderBelow(float alphaMult) {
      if(this.pos != null && this.difficulty != null) {
         GL11.glPushMatrix();
         GL11.glDisable(3553);
         GL11.glEnable(3042);
         Color darkerColor = Misc.scaleColor(this.difficulty.color, 0.1F);
         GL11.glBegin(7);
         GL11.glColor3ub((byte)darkerColor.getRed(), (byte)darkerColor.getGreen(), (byte)darkerColor.getBlue());
         GL11.glVertex2f(this.pos.getX(), this.pos.getY() + this.pos.getHeight());
         GL11.glVertex2f(this.pos.getX() + this.pos.getWidth(), this.pos.getY() + this.pos.getHeight());
         GL11.glColor3ub((byte)0, (byte)0, (byte)0);
         GL11.glVertex2f(this.pos.getX() + this.pos.getWidth(), this.pos.getY());
         GL11.glVertex2f(this.pos.getX(), this.pos.getY());
         GL11.glEnd();
         GL11.glPopMatrix();
      }

   }

   public void buttonPressed(Object buttonId) {
      LOGGER.info(buttonId);
      this.triggerPresetEvents(buttonId);
      String btnId = buttonId.toString();
      byte var4 = -1;
      switch(btnId.hashCode()) {
      case -713707361:
         if(btnId.equals("clear_negative_rules")) {
            var4 = 1;
         }
         break;
      case -305603741:
         if(btnId.equals("clear_positive_rules")) {
            var4 = 0;
         }
      }

      switch(var4) {
      case 0:
         this.resetSpecificRuleButtons(true);
         break;
      case 1:
         this.resetSpecificRuleButtons(false);
      }

      this.triggerRuleEvents((ButtonAPI)null);
      var4 = -1;
      switch(btnId.hashCode()) {
      case -1367724422:
         if(btnId.equals("cancel")) {
            var4 = 1;
         }
         break;
      case 951117504:
         if(btnId.equals("confirm")) {
            var4 = 0;
         }
      }

      switch(var4) {
      case 0:
         this.pickedRules.clear();
         Iterator var5 = this.allRuleButtons.iterator();

         while(var5.hasNext()) {
            ButtonAPI ruleButton = (ButtonAPI)var5.next();
            if(ruleButton.isChecked()) {
               URule rule = (URule)ruleButton.getCustomData();
               if(rule != null) {
                  this.pickedRules.add(rule);
               }
            }
         }

         this.onConfirm.run();
         this.exit();
         break;
      case 1:
         this.exit();
      }

   }

   public void buttonPressed(ButtonAPI ruleButton) {
      this.triggerRuleEvents(ruleButton);
   }

   private void resetAllRuleButtons() {
      Iterator var1 = this.allRuleButtons.iterator();

      while(var1.hasNext()) {
         ButtonAPI ruleButton = (ButtonAPI)var1.next();
         ruleButton.setChecked(false);
         ruleButton.setEnabled(true);
      }

   }

   private void resetSpecificRuleButtons(boolean isPositive) {
      Iterator var2 = this.allRuleButtons.iterator();

      while(var2.hasNext()) {
         ButtonAPI ruleButton = (ButtonAPI)var2.next();
         URule rule = (URule)ruleButton.getCustomData();
         if(rule != null && rule.isPositive() == isPositive) {
            ruleButton.setChecked(false);
            ruleButton.setEnabled(true);
         }
      }

   }

   private void triggerPresetEvents(Object buttonId) {
      this.presetCheckboxGroup.updateCheck();
      String presetSlot = (String)this.presetCheckboxGroup.getCheckedValue();
      if(presetSlot != null) {
         this.presetLoadBtn.setEnabled(UNGP_RulePickPresetManager.isPresetExists(presetSlot));
         Iterator var4;
         ButtonAPI ruleButton;
         URule rule;
         if("preset_save".equals(buttonId)) {
            ArrayList rules = new ArrayList();
            var4 = this.allRuleButtons.iterator();

            while(var4.hasNext()) {
               ruleButton = (ButtonAPI)var4.next();
               if(ruleButton.isChecked()) {
                  rule = (URule)ruleButton.getCustomData();
                  if(rule != null) {
                     rules.add(rule);
                  }
               }
            }

            UNGP_RulePickPresetManager.save(presetSlot, rules);
         } else if("preset_load".equals(buttonId)) {
            List rules1 = UNGP_RulePickPresetManager.load(presetSlot);
            if(!rules1.isEmpty()) {
               this.resetAllRuleButtons();
               var4 = this.allRuleButtons.iterator();

               while(var4.hasNext()) {
                  ruleButton = (ButtonAPI)var4.next();
                  rule = (URule)ruleButton.getCustomData();
                  if(rule != null) {
                     ruleButton.setChecked(rules1.contains(rule));
                  }
               }

               this.triggerRuleEvents((ButtonAPI)null);
               this.triggerPresetEvents((Object)null);
            }
         }
      }

   }

   private void triggerRuleEvents(ButtonAPI pressedRuleButton) {
      if(pressedRuleButton != null) {
         this.updateGoldenRuleButtonStatus(pressedRuleButton);
      } else {
         ButtonAPI checkedGoldenBtn = null;
         Iterator var3 = this.allRuleButtons.iterator();

         while(var3.hasNext()) {
            ButtonAPI ruleButton = (ButtonAPI)var3.next();
            URule rule = (URule)ruleButton.getCustomData();
            if(ruleButton.isChecked() && rule != null && rule.isGolden()) {
               checkedGoldenBtn = ruleButton;
               break;
            }
         }

         if(checkedGoldenBtn != null) {
            this.updateGoldenRuleButtonStatus(checkedGoldenBtn);
         }
      }

      this.updateRuleThings();
   }

   private void updateRuleThings() {
      Object positiveCount = 0;
      Object negativeCount = 0;
      boolean totalCount = false;
      Object cost = false;
      ArrayList curPickedRules = new ArrayList();
      this.positiveRuleSummaryContentSect.removeLatestSubPanel();
      this.negativeRuleSummaryContentSect.removeLatestSubPanel();
      this.reasonUnmetSect.removeLatestSubPanel();
      CustomPanelAPI positivePanel = this.positiveRuleSummaryContentSect.createSubPanel(this.panel, (CustomUIPanelPlugin)null).getPanel();
      CustomPanelAPI negativePanel = this.negativeRuleSummaryContentSect.createSubPanel(this.panel, (CustomUIPanelPlugin)null).getPanel();
      CustomPanelAPI reasonUnmetPanel = this.reasonUnmetSect.createSubPanel(this.panel, (CustomUIPanelPlugin)null).getPanel();
      TooltipMakerAPI positiveTooltip = positivePanel.createUIElement(this.positiveRuleSummaryContentSect.getWidth(), this.positiveRuleSummaryContentSect.getHeight(), true);
      TooltipMakerAPI negativeTooltip = negativePanel.createUIElement(this.negativeRuleSummaryContentSect.getWidth(), this.negativeRuleSummaryContentSect.getHeight(), true);
      TooltipMakerAPI reasonUnmetTooltip = reasonUnmetPanel.createUIElement(this.reasonUnmetSect.getWidth(), this.reasonUnmetSect.getHeight(), true);
      positiveTooltip.addSpacer(5.0F);
      negativeTooltip.addSpacer(5.0F);
      Iterator runnableChallenges = this.allRuleButtons.iterator();

      while(runnableChallenges.hasNext()) {
         ButtonAPI extraString = (ButtonAPI)runnableChallenges.next();
         if(extraString.isChecked()) {
            URule resultString = (URule)extraString.getCustomData();
            if(resultString != null) {
               TooltipMakerAPI isConfirmBtnEnabled;
               if(resultString.isPositive()) {
                  ++positiveCount;
                  isConfirmBtnEnabled = positiveTooltip.beginImageWithText(resultString.getSpritePath(), 32.0F);
                  isConfirmBtnEnabled.addPara(resultString.getName(), resultString.getCorrectColor(), 0.0F);
                  resultString.addShortDesc(isConfirmBtnEnabled, 0.0F);
                  positiveTooltip.addImageWithText(2.0F);
               } else {
                  ++negativeCount;
                  isConfirmBtnEnabled = negativeTooltip.beginImageWithText(resultString.getSpritePath(), 32.0F);
                  isConfirmBtnEnabled.addPara(resultString.getName(), resultString.getCorrectColor(), 0.0F);
                  resultString.addShortDesc(isConfirmBtnEnabled, 0.0F);
                  negativeTooltip.addImageWithText(2.0F);
               }

               cost += resultString.getCost();
               curPickedRules.add(resultString);
            }
         }
      }

      positivePanel.addUIElement(positiveTooltip);
      negativePanel.addUIElement(negativeTooltip);
      int var18 = positiveCount + negativeCount;
      List var19 = UNGP_ChallengeManager.getRunnableChallenges(this.difficulty, curPickedRules, this.completedChallenges);
      this.challengeContentSect.removeLatestSubPanel();
      CustomPanelAPI var20;
      TooltipMakerAPI var22;
      if(!var19.isEmpty()) {
         var20 = this.challengeContentSect.createSubPanel(this.panel, (CustomUIPanelPlugin)null).getPanel();
         var22 = var20.createUIElement(this.challengeContentSect.getWidth(), this.challengeContentSect.getHeight(), true);
         var22.addSpacer(5.0F);
         Iterator var23 = var19.iterator();

         while(var23.hasNext()) {
            UNGP_ChallengeInfo runnableChallenge = (UNGP_ChallengeInfo)var23.next();
            runnableChallenge.createTooltip(var22, 0.0F, (UNGP_ChallengeProgress)null);
         }

         var20.addUIElement(var22);
      } else if(!UNGP_ChallengeManager.isDifficultyEnough(this.difficulty)) {
         var20 = this.challengeContentSect.createSubPanel(this.panel, (CustomUIPanelPlugin)null).getPanel();
         var22 = var20.createUIElement(this.challengeContentSect.getWidth(), this.challengeContentSect.getHeight(), true);
         var22.setParaOrbitronLarge();
         var22.addPara(Constants.rules_i18n.format("challenge_tip_difficultyNotMeet", new Object[]{Difficulty.ALPHA.name, Difficulty.OMEGA.name}), Misc.getNegativeHighlightColor(), 10.0F).setAlignment(Alignment.MID);
         var20.addUIElement(var22);
      }

      this.positiveRuleCount.setText(Constants.rules_i18n.format("pick_rule_count", new Object[]{positiveCount, UNGP_RulesManager.getPNRuleString(true)}));
      this.positiveRuleCount.setHighlight(new String[]{(String)positiveCount, UNGP_RulesManager.getPNRuleString(true)});
      this.positiveRuleCount.setHighlightColors(new Color[]{Misc.getHighlightColor(), UNGP_RulesManager.getPNColor(true)});
      this.negativeRuleCount.setText(Constants.rules_i18n.format("pick_rule_count", new Object[]{negativeCount, UNGP_RulesManager.getPNRuleString(false)}));
      this.negativeRuleCount.setHighlight(new String[]{(String)negativeCount, UNGP_RulesManager.getPNRuleString(false)});
      this.negativeRuleCount.setHighlightColors(new Color[]{Misc.getHighlightColor(), UNGP_RulesManager.getPNColor(false)});
      this.l_curCost.setText(String.format(Constants.rules_i18n.get("pick_rule_cur_cost"), new Object[]{cost}));
      this.l_curCost.setHighlight(new String[]{(String)cost});
      this.l_curCost.setHighlightColor(cost >= 0?Misc.getPositiveHighlightColor():Misc.getNegativeHighlightColor());
      String var21 = "";
      if(var18 < this.difficulty.minRules) {
         var21 = this.difficulty.minRules;
      }

      if(var18 > this.difficulty.maxRules) {
         var21 = this.difficulty.maxRules;
      }

      this.l_curRuleCount.setText(String.format(Constants.rules_i18n.get("pick_rule_cur_rule_count"), new Object[]{var21}));
      this.l_curRuleCount.setHighlight(new String[]{var21});
      this.l_curRuleCount.setHighlightColor(var21.isEmpty()?Misc.getPositiveHighlightColor():Misc.getNegativeHighlightColor());
      boolean var24 = true;
      reasonUnmetTooltip.setParaOrbitronLarge();
      Iterator var25 = UNGP_RulePickHelper.generateUnmetReasons(curPickedRules, this.difficulty).iterator();

      while(var25.hasNext()) {
         UnmetReason unmetReason = (UnmetReason)var25.next();
         var24 = false;
         reasonUnmetTooltip.addPara(Constants.rules_i18n.get(unmetReason.getType().getI18nKey()), Misc.getNegativeHighlightColor(), 5.0F);
      }

      if(var24) {
         reasonUnmetTooltip.addPara(Constants.rules_i18n.get("unmet_none"), Misc.getPositiveHighlightColor(), 5.0F);
      }

      reasonUnmetPanel.addUIElement(reasonUnmetTooltip);
      this.confirmBtn.setEnabled(var24);
   }

   private void updateGoldenRuleButtonStatus(ButtonAPI pressedRuleButton) {
      URule pressedRule = (URule)pressedRuleButton.getCustomData();
      if(pressedRule.isGolden()) {
         Iterator var3;
         ButtonAPI button;
         URule rule;
         if(pressedRuleButton.isChecked()) {
            var3 = this.allRuleButtons.iterator();

            while(var3.hasNext()) {
               button = (ButtonAPI)var3.next();
               rule = (URule)button.getCustomData();
               if(rule != null && pressedRule != rule && rule.isGolden()) {
                  button.setChecked(false);
                  button.setEnabled(false);
               }
            }
         } else {
            var3 = this.allRuleButtons.iterator();

            while(var3.hasNext()) {
               button = (ButtonAPI)var3.next();
               rule = (URule)button.getCustomData();
               if(rule != null && pressedRule != rule && rule.isGolden()) {
                  button.setChecked(false);
                  button.setEnabled(true);
               }
            }
         }
      }

   }

   public void processInput(List events) {
      if(this.pos != null) {
         ;
      }
   }

   public void exit() {
      this.callbacks.dismissDialog();
      UNGP_ChallengeManager.getTemporaryCompletedChallenges().clear();
      Global.getSoundPlayer().playCustomMusic(1, 1, (String)null);
      if(this.onCancel != null) {
         this.onCancel.run();
      }

   }

}
