package ungp.scripts.campaign.ui;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI.TooltipLocation;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.opengl.GL11;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;

public class UNGP_RulePickItemPanelPlugin extends BaseCustomUIPanelPlugin {

   public static final float ITEM_SIZE = 112.0F;
   public static final float RULE_ICON_SIZE = 64.0F;
   private PositionAPI p;
   private URule rule;
   private CustomPanelAPI panel;
   private ButtonAPI linkedButton;
   private UNGP_RulePickItemPanelPlugin.ButtonPressListener pressListener;
   private SpriteAPI ruleSprite;
   protected FaderUtil highlightBlinker = new FaderUtil(0.0F, 0.25F, 0.25F, true, true);


   public UNGP_RulePickItemPanelPlugin(URule rule, UNGP_RulePickItemPanelPlugin.ButtonPressListener pressListener) {
      this.rule = rule;
      this.ruleSprite = Global.getSettings().getSprite(rule.getSpritePath());
      this.pressListener = pressListener;
   }

   public void init(CustomPanelAPI panel) {
      this.panel = panel;
      TooltipMakerAPI element = panel.createUIElement(this.p.getWidth(), this.p.getHeight(), false);
      Color borderAndDarkColor = Misc.scaleColorOnly(this.rule.getCorrectColor(), 0.2F);
      this.linkedButton = element.addAreaCheckbox("", this.rule.getId(), this.rule.getCorrectColor(), borderAndDarkColor, Misc.getBrightPlayerColor(), this.p.getWidth(), this.p.getHeight(), 0.0F);
      this.linkedButton.getPosition().setXAlignOffset(-0.5F);
      this.linkedButton.setCustomData(this.rule);
      this.linkedButton.setButtonPressedSound((String)null);
      if(this.rule.isPositive()) {
         element.addTooltipToPrevious(UNGP_RulesManager.createRuleItemTooltip(this.rule), TooltipLocation.BELOW);
      } else {
         element.addTooltipToPrevious(UNGP_RulesManager.createRuleItemTooltip(this.rule), TooltipLocation.ABOVE);
      }

      panel.addUIElement(element);
      TooltipMakerAPI labelElement = panel.createUIElement(this.p.getWidth(), this.p.getHeight(), false);
      labelElement.addSpacer(this.p.getHeight() * 0.08F);
      LabelAPI labelAPI = labelElement.addPara(this.rule.getName(), this.rule.getCorrectColor(), 0.0F);
      labelAPI.setAlignment(Alignment.MID);
      panel.addUIElement(labelElement);
      TooltipMakerAPI costElement = panel.createUIElement(this.p.getWidth(), 22.0F, false);
      costElement.setParaOrbitronLarge();
      costElement.addPara(this.rule.getCostString(), this.rule.getCostColor(), 0.0F).setAlignment(Alignment.MID);
      panel.addUIElement(costElement);
      this.highlightBlinker.fadeIn();
   }

   public static CustomPanelAPI createCustom(URule rule, UNGP_RulePickItemPanelPlugin.ButtonPressListener pressListener) {
      UNGP_RulePickItemPanelPlugin plugin = new UNGP_RulePickItemPanelPlugin(rule, pressListener);
      CustomPanelAPI panel = Global.getSettings().createCustom(112.0F, 112.0F, plugin);
      plugin.init(panel);
      return panel;
   }

   public void positionChanged(PositionAPI position) {
      this.p = position;
   }

   public void advance(float amount) {
      this.highlightBlinker.advance(amount * 0.2F);
   }

   public void render(float alphaMult) {
      if(this.p != null) {
         boolean isEnabled = this.linkedButton.isEnabled();
         GL11.glPushMatrix();
         GL11.glDisable(3553);
         GL11.glEnable(3042);
         GL11.glBlendFunc(770, 1);
         if(!isEnabled) {
            this.ruleSprite.setColor(Color.gray);
         } else {
            this.ruleSprite.setColor(Color.white);
         }

         this.ruleSprite.setAlphaMult(alphaMult);
         this.ruleSprite.setSize(64.0F, 64.0F);
         float cx = this.p.getX() + this.p.getWidth() * 0.5F;
         float cy = this.p.getY() + this.p.getHeight() * 0.5F;
         this.ruleSprite.renderAtCenter(cx, cy);
         boolean isGoldenOrMilestone = this.rule.isGolden() || this.rule.isMilestone();
         if(isGoldenOrMilestone && isEnabled && this.highlightBlinker.isFadingIn()) {
            float factor = this.highlightBlinker.getBrightness();
            this.ruleSprite.setColor(UNGP_RulesManager.getGoldenColor());
            this.ruleSprite.setAdditiveBlend();
            float tmp_h = 0.1F;
            float tmp_y = 1.0F + tmp_h - (1.0F + 2.0F * tmp_h) * factor;
            float th = tmp_h;
            float ty = MathUtils.clamp(tmp_y, 0.0F, 1.0F);
            if(tmp_y > 1.0F - tmp_h) {
               th = tmp_y > 1.0F?0.0F:1.0F - tmp_y;
            }

            if(tmp_y < 0.0F) {
               th = tmp_h + tmp_y;
            }

            this.ruleSprite.renderRegionAtCenter(cx, cy, 0.0F, ty, 1.0F, th);
         }

         GL11.glPopMatrix();
      }
   }

   public void renderBelow(float alphaMult) {
      if(this.p != null) {
         ;
      }
   }

   public ButtonAPI getLinkedButton() {
      return this.linkedButton;
   }

   public void buttonPressed(Object buttonId) {
      String soundId;
      if(this.rule.isMilestone()) {
         soundId = this.linkedButton.isChecked()?"ui_milestone_pickup":"ui_milestone_drop";
      } else if(this.rule.isGolden()) {
         soundId = this.linkedButton.isChecked()?"ui_golden_pickup":"ui_golden_drop";
      } else if(this.rule.isPositive()) {
         soundId = this.linkedButton.isChecked()?"ui_positive_pickup":"ui_positive_drop";
      } else {
         soundId = this.linkedButton.isChecked()?"ui_negative_pickup":"ui_negative_drop";
      }

      Global.getSoundPlayer().playUISound(soundId, 1.0F, 1.0F);
      this.pressListener.notifyPressed(this.linkedButton);
   }

   public interface ButtonPressListener {

      void notifyPressed(ButtonAPI var1);
   }
}
