package ungp.scripts.campaign.ui;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lazywizard.lazylib.FastTrig;
import org.lwjgl.opengl.GL11;

public class UNGP_InteractionPanelPlugin extends BaseCustomUIPanelPlugin {

   private CustomPanelAPI customPanel;
   private PositionAPI pos;
   private float elapsed = 0.0F;
   private float lastYOffset = 0.0F;
   private SpriteAPI sprite = Global.getSettings().getSprite("illustrations", "UNGP_logo");
   private List currentComponents = new ArrayList();


   public void update(VisualPanelAPI visualPanel) {
      this.clearUIComponents();
      this.lastYOffset = 0.0F;
      this.customPanel = visualPanel.showCustomPanel(400.0F, 300.0F, this);
   }

   public TooltipMakerAPI beginTooltip(float height, boolean withScroller) {
      TooltipMakerAPI tooltip = this.customPanel.createUIElement(this.pos.getWidth(), height, withScroller);
      this.currentComponents.add(tooltip);
      return tooltip;
   }

   public void addTooltip(float height, TooltipMakerAPI tooltip) {
      this.customPanel.addUIElement(tooltip).inTL(0.0F, this.lastYOffset);
      this.lastYOffset += height;
   }

   public void clearUIComponents() {
      Iterator var1 = this.currentComponents.iterator();

      while(var1.hasNext()) {
         UIComponentAPI component = (UIComponentAPI)var1.next();
         this.customPanel.removeComponent(component);
      }

      this.currentComponents.clear();
   }

   public void positionChanged(PositionAPI position) {
      this.pos = position;
   }

   public void renderBelow(float alphaMult) {
   }

   private void drawBorder(float alphaMult) {
      float x = this.pos.getX();
      float y = this.pos.getY();
      float w = this.pos.getWidth();
      float h = this.pos.getHeight();
      GL11.glPushMatrix();
      GL11.glDisable(3553);
      GL11.glEnable(3042);
      GL11.glBlendFunc(770, 771);
      Color color = Color.cyan;
      GL11.glColor4f((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, (float)((double)alphaMult * (0.75D + FastTrig.cos((double)(-this.elapsed)) * 0.25D)));
      GL11.glBegin(2);
      GL11.glVertex2f(x, y);
      GL11.glVertex2f(x + w, y);
      GL11.glVertex2f(x + w, y + h);
      GL11.glVertex2f(x, y + h);
      GL11.glEnd();
      GL11.glPopMatrix();
   }

   public void render(float alphaMult) {
      if(this.currentComponents.isEmpty()) {
         this.sprite.setAlphaMult(alphaMult);
         float centerX = this.pos.getCenterX();
         float centerY = this.pos.getCenterY();
         this.sprite.renderAtCenter(centerX, centerY);
      }
   }

   public void advance(float amount) {
      this.elapsed += amount;
   }

   public void processInput(List events) {
   }
}
