package ungp.scripts.campaign.ui;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BaseCustomDialogDelegate;
import com.fs.starfarer.api.campaign.BaseStoryPointActionDelegate;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.CustomDialogDelegate.CustomDialogCallback;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI.TooltipCreator;
import com.fs.starfarer.api.ui.TooltipMakerAPI.TooltipLocation;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ungp.api.backgrounds.UNGP_BackgroundPluginAPI;
import ungp.api.saves.UNGP_DataSaverAPI;
import ungp.api.saves.UNGP_DataSaverSettingEntryAPI;
import ungp.impl.saves.UNGP_BlueprintsDataSaver;
import ungp.impl.saves.UNGP_CreditsDataSaver;
import ungp.scripts.campaign.UNGP_InGameData;
import ungp.scripts.campaign.UNGP_Settings;
import ungp.scripts.campaign.background.UNGP_Background;
import ungp.scripts.campaign.background.UNGP_BackgroundManager;
import ungp.scripts.campaign.background.UNGP_Background.BackgroundTooltipCreator;
import ungp.scripts.campaign.inherit.UNGP_InheritData;
import ungp.scripts.campaign.inherit.UNGP_InheritManager;
import ungp.scripts.campaign.intel.UNGP_BackgroundIntel;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings;
import ungp.scripts.campaign.specialist.UNGP_SpecialistSettings.Difficulty;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeInfo;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeManager;
import ungp.scripts.campaign.specialist.challenges.UNGP_ChallengeProgress;
import ungp.scripts.campaign.specialist.intel.UNGP_ChallengeIntel;
import ungp.scripts.campaign.specialist.intel.UNGP_SpecialistIntel;
import ungp.scripts.campaign.specialist.rules.UNGP_RulePickHelper;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager;
import ungp.scripts.campaign.specialist.rules.UNGP_RulesManager.URule;
import ungp.scripts.campaign.ui.UNGP_InteractionPanelPlugin;
import ungp.scripts.campaign.ui.UNGP_RulePickPanelDelegate;
import ungp.scripts.campaign.ui.UNGP_RulePickPanelPlugin;
import ungp.scripts.ui.CheckBoxGroup;
import ungp.scripts.ui.HorizontalButtonGroup;
import ungp.scripts.ui.SettingEntry;
import ungp.scripts.utils.Constants;
import ungp.scripts.utils.UNGP_Feedback;

public class UNGP_InteractionDialog implements InteractionDialogPlugin {

   private InteractionDialogAPI dialog;
   private TextPanelAPI textPanel;
   private OptionPanelAPI options;
   private VisualPanelAPI visual;
   private UNGP_InteractionPanelPlugin uiPanelPlugin;
   private UNGP_InGameData inGameData;
   private boolean onlyDefaultSlot;
   private UNGP_InheritData pickedInheritData;
   private UNGP_InteractionDialog.OptionID choseInheritSlotOptionID = null;
   private UNGP_InheritData pregenInheritData;
   private boolean isSpecialistMode = false;
   private UNGP_InteractionDialog.InheritSettingEntry settingEntry_difficulty = new UNGP_InteractionDialog.InheritSettingEntry((Object)null, Difficulty.values().length + 1) {
      public void initParams(int optionSize) {
         this.entryTitle = Constants.root_i18n.get("hardmodeLevel");
         this.entryTitleColor = Misc.getNegativeHighlightColor();

         for(int i = 0; i < optionSize; ++i) {
            Difficulty difficulty;
            if(i == 0) {
               difficulty = null;
               this.optionNames[i] = "/";
               this.optionBaseColor[i] = Misc.getBasePlayerColor();
               this.optionDarkColor[i] = Misc.getDarkPlayerColor();
               this.optionBrightColor[i] = Misc.getBrightPlayerColor();
            } else {
               difficulty = Difficulty.values()[i - 1];
               this.optionNames[i] = difficulty.name;
               this.optionBaseColor[i] = difficulty.color;
               this.optionDarkColor[i] = difficulty.color.darker();
               this.optionBrightColor[i] = difficulty.color.brighter();
            }

            this.optionValues[i] = difficulty;
         }

      }
      protected void addTipToOption(TooltipMakerAPI tooltip, Object option) {
         Difficulty difficulty = (Difficulty)option;
         tooltip.addTooltipToPrevious(new UNGP_InteractionDialog.DifficultyTooltipCreator(difficulty), TooltipLocation.BELOW);
      }
   };
   private List pickedRules = new ArrayList();
   private UNGP_Background pickedBackground;
   private CheckBoxGroup backgroundCheckBoxGroup;


   public UNGP_InteractionDialog(UNGP_InGameData inGameData) {
      this.inGameData = inGameData;
   }

   public void init(InteractionDialogAPI dialog) {
      this.dialog = dialog;
      dialog.setPromptText("");
      dialog.setBackgroundDimAmount(0.4F);
      this.textPanel = dialog.getTextPanel();
      this.options = dialog.getOptionPanel();
      this.visual = dialog.getVisualPanel();
      this.pregenInheritData = UNGP_InheritData.createInheritData(this.inGameData);
      this.onlyDefaultSlot = UNGP_InheritManager.loadAllSlots();
      this.uiPanelPlugin = new UNGP_InteractionPanelPlugin();
      this.uiPanelPlugin.update(this.visual);
      this.initMenu();
      dialog.setOptionOnEscape((String)null, UNGP_InteractionDialog.OptionID.LEAVE);
   }

   private void initMenu() {
      this.textPanel.addPara(Constants.root_i18n.get("menu"));
      this.options.addOption(Constants.root_i18n.get("checkInherit"), UNGP_InteractionDialog.OptionID.CHECK_INHERIT_SLOTS);
      this.options.addOption(Constants.root_i18n.get("checkRecord"), UNGP_InteractionDialog.OptionID.CHECK_RECORD_SLOTS);
      if(!this.inGameData.isInherited() && this.inGameData.isPassedInheritTime()) {
         this.textPanel.addPara(Constants.root_i18n.get("hasPassedTime"), Misc.getNegativeHighlightColor());
      }

      if(!this.inGameData.couldStartRecord()) {
         this.options.setEnabled(UNGP_InteractionDialog.OptionID.CHECK_RECORD_SLOTS, false);
         if(this.inGameData.isRecorded()) {
            this.textPanel.addPara(Constants.root_i18n.get("hasRecorded"), Misc.getNegativeHighlightColor());
         }

         if(!UNGP_Settings.reachMaxLevel()) {
            this.textPanel.addPara(Constants.root_i18n.get("notMaxLevel"), Misc.getNegativeHighlightColor());
         }
      }

      TooltipMakerAPI toRecordInfo = this.textPanel.beginTooltip();
      Difficulty difficulty = null;
      if(this.inGameData.isHardMode()) {
         difficulty = this.inGameData.getDifficulty();
      }

      this.pregenInheritData.addRecordTooltip(toRecordInfo, difficulty);
      this.textPanel.addTooltip();
      this.options.addOption(Constants.root_i18n.get("help"), UNGP_InteractionDialog.OptionID.HELP);
      this.addLeaveButton();
   }

   private void optionSelectedChooseInherit(UNGP_InteractionDialog.OptionID option) {
      this.pickedInheritData = UNGP_InheritManager.getDataFromSlot(this.getSlotIdByOption(option));
      Color nC = Misc.getNegativeHighlightColor();
      if(this.pickedInheritData != null) {
         this.choseInheritSlotOptionID = option;
         TooltipMakerAPI inheritDataInfo = this.textPanel.beginTooltip();
         this.pickedInheritData.addInheritTooltip(inheritDataInfo);
         this.textPanel.addTooltip();
         if(!this.inGameData.isPassedInheritTime() && !this.inGameData.isInherited()) {
            String settingOptionStr = Constants.root_i18n.get("startSetting");
            this.options.addOption(settingOptionStr, UNGP_InteractionDialog.OptionID.INHERIT_SETTINGS);
            this.options.setShortcut(UNGP_InteractionDialog.OptionID.INHERIT_SETTINGS, 31, false, false, false, true);
            if(this.isSpecialistMode) {
               OptionPanelAPI var10000 = this.options;
               Constants.root_i18n.get("rulepick_button").addOption(UNGP_ChallengeManager.isDifficultyEnough((Difficulty)this.settingEntry_difficulty.getValue())?Constants.root_i18n.get("rulepick_couldChallenge"):"", UNGP_InteractionDialog.OptionID.PICK_RULES_NEW);
               this.options.setShortcut(UNGP_InteractionDialog.OptionID.PICK_RULES_NEW, 19, false, false, false, true);
               this.pickedRules.clear();
            }

            this.options.addOption(Constants.root_i18n.get("startInherit"), UNGP_InteractionDialog.OptionID.INHERIT);
            this.options.setShortcut(UNGP_InteractionDialog.OptionID.INHERIT, 57, false, false, false, true);
            this.updateOptionsFromSettings();
         } else if(this.inGameData.isInherited()) {
            this.textPanel.addPara(Constants.root_i18n.get("hasInherited"), nC);
         } else {
            this.textPanel.addPara(Constants.root_i18n.get("hasPassedTime"), nC);
         }
      } else {
         this.textPanel.addPara(Constants.root_i18n.get("noInherit"), nC);
      }

   }

   private void saveRecordByChosenOption(UNGP_InheritData dataToRecord, UNGP_InteractionDialog.OptionID option) {
      UNGP_InheritManager.saveDataToSlot(dataToRecord, this.getSlotIdByOption(option));
   }

   public int getSlotIdByOption(UNGP_InteractionDialog.OptionID option) {
      byte slotID = 0;
      switch(null.$SwitchMap$ungp$scripts$campaign$ui$UNGP_InteractionDialog$OptionID[option.ordinal()]) {
      case 1:
      case 2:
      default:
         break;
      case 3:
      case 4:
         slotID = 1;
         break;
      case 5:
      case 6:
         slotID = 2;
      }

      return slotID;
   }

   public void optionSelected(String optionText, Object optionData) {
      UNGP_InteractionDialog.OptionID selectedOption = (UNGP_InteractionDialog.OptionID)optionData;
      if(selectedOption != UNGP_InteractionDialog.OptionID.PICK_RULES_NEW) {
         this.options.clearOptions();
         this.textPanel.clear();
         this.uiPanelPlugin.update(this.visual);
      }

      float width;
      float height;
      final Difficulty difficulty;
      UNGP_InheritData height1;
      OptionPanelAPI var10000;
      OptionPanelAPI var10001;
      OptionPanelAPI var10002;
      switch(null.$SwitchMap$ungp$scripts$campaign$ui$UNGP_InteractionDialog$OptionID[selectedOption.ordinal()]) {
      case 1:
      case 3:
      case 5:
         this.dialog.showCustomDialog(720.0F, 200.0F, new UNGP_InteractionDialog.RecordDialogDelegate(selectedOption));
         this.addLeaveButton();
         break;
      case 2:
      case 4:
      case 6:
         this.optionSelectedChooseInherit(selectedOption);
         this.addBackButton(UNGP_InteractionDialog.OptionID.CHECK_INHERIT_SLOTS);
         break;
      case 7:
         this.resetSettings();
         if(!this.onlyDefaultSlot) {
            this.textPanel.addPara(Constants.root_i18n.get("checkInherit"));
            this.textPanel.addPara(Constants.root_i18n.get("checkInheritSlot"));
            UNGP_InheritData width2 = UNGP_InheritManager.InheritData_slot0;
            if(width2 == null) {
               this.options.addOption(Constants.root_i18n.get("emptySlot"), UNGP_InteractionDialog.OptionID.CHOOSE_INHERIT_SLOT_0);
               this.options.setEnabled(UNGP_InteractionDialog.OptionID.CHOOSE_INHERIT_SLOT_0, false);
            } else {
               height1 = Math.max(0, width2.cycle);
               var10000 = this.options;
               width2.getPrefixByCycle().addOption(Constants.root_i18n.format("slotDes", new Object[]{height1, width2.lastPlayerName}), UNGP_InteractionDialog.OptionID.CHOOSE_INHERIT_SLOT_0, width2.getColorByCycle(), (String)null);
            }

            width2 = UNGP_InheritManager.InheritData_slot1;
            if(width2 == null) {
               this.options.addOption(Constants.root_i18n.get("emptySlot"), UNGP_InteractionDialog.OptionID.CHOOSE_INHERIT_SLOT_1);
               this.options.setEnabled(UNGP_InteractionDialog.OptionID.CHOOSE_INHERIT_SLOT_1, false);
            } else {
               height1 = Math.max(0, width2.cycle);
               var10001 = this.options;
               width2.getPrefixByCycle().addOption(Constants.root_i18n.format("slotDes", new Object[]{height1, width2.lastPlayerName}), UNGP_InteractionDialog.OptionID.CHOOSE_INHERIT_SLOT_1, width2.getColorByCycle(), (String)null);
            }

            width2 = UNGP_InheritManager.InheritData_slot2;
            if(width2 == null) {
               this.options.addOption(Constants.root_i18n.get("emptySlot"), UNGP_InteractionDialog.OptionID.CHOOSE_INHERIT_SLOT_2);
               this.options.setEnabled(UNGP_InteractionDialog.OptionID.CHOOSE_INHERIT_SLOT_2, false);
            } else {
               height1 = Math.max(0, width2.cycle);
               var10002 = this.options;
               width2.getPrefixByCycle().addOption(Constants.root_i18n.format("slotDes", new Object[]{height1, width2.lastPlayerName}), UNGP_InteractionDialog.OptionID.CHOOSE_INHERIT_SLOT_2, width2.getColorByCycle(), (String)null);
            }
         } else {
            this.optionSelectedChooseInherit(UNGP_InteractionDialog.OptionID.CHOOSE_INHERIT_SLOT_0);
         }

         this.addBackButton(UNGP_InteractionDialog.OptionID.BACK_TO_MENU);
         break;
      case 8:
         TooltipMakerAPI width1 = this.textPanel.beginTooltip();
         this.textPanel.addPara(Constants.root_i18n.get("recordInfo"));
         this.pregenInheritData.addRecordTooltip(width1, this.inGameData.getDifficulty());
         this.textPanel.addTooltip();
         this.textPanel.addPara(Constants.root_i18n.get("checkRecordSlot"));
         height1 = UNGP_InheritManager.InheritData_slot0;
         if(height1 == null) {
            this.options.addOption(Constants.root_i18n.get("emptySlot"), UNGP_InteractionDialog.OptionID.CHOOSE_RECORD_SLOT_0);
         } else {
            difficulty = Math.max(0, height1.cycle);
            var10000 = this.options;
            height1.getPrefixByCycle().addOption(Constants.root_i18n.format("slotDes", new Object[]{difficulty, height1.lastPlayerName}), UNGP_InteractionDialog.OptionID.CHOOSE_RECORD_SLOT_0, height1.getColorByCycle(), (String)null);
         }

         height1 = UNGP_InheritManager.InheritData_slot1;
         if(height1 == null) {
            this.options.addOption(Constants.root_i18n.get("emptySlot"), UNGP_InteractionDialog.OptionID.CHOOSE_RECORD_SLOT_1);
         } else {
            difficulty = Math.max(0, height1.cycle);
            var10001 = this.options;
            height1.getPrefixByCycle().addOption(Constants.root_i18n.format("slotDes", new Object[]{difficulty, height1.lastPlayerName}), UNGP_InteractionDialog.OptionID.CHOOSE_RECORD_SLOT_1, height1.getColorByCycle(), (String)null);
         }

         height1 = UNGP_InheritManager.InheritData_slot2;
         if(height1 == null) {
            this.options.addOption(Constants.root_i18n.get("emptySlot"), UNGP_InteractionDialog.OptionID.CHOOSE_RECORD_SLOT_2);
         } else {
            difficulty = Math.max(0, height1.cycle);
            var10002 = this.options;
            height1.getPrefixByCycle().addOption(Constants.root_i18n.format("slotDes", new Object[]{difficulty, height1.lastPlayerName}), UNGP_InteractionDialog.OptionID.CHOOSE_RECORD_SLOT_2, height1.getColorByCycle(), (String)null);
         }

         this.addBackButton(UNGP_InteractionDialog.OptionID.BACK_TO_MENU);
         break;
      case 9:
         this.textPanel.addPara(Constants.root_i18n.get("helpInfo"));
         this.addBackButton(UNGP_InteractionDialog.OptionID.BACK_TO_MENU);
         break;
      case 10:
         width = Global.getSettings().getScreenWidth();
         height = Global.getSettings().getScreenHeight();
         difficulty = (Difficulty)this.settingEntry_difficulty.getValue();
         UNGP_RulesManager.setStaticDifficulty(difficulty);
         Script pickTrigger = new Script() {
            public void run() {
               UNGP_InteractionDialog.this.setSpecialistModeToolTip();
               UNGP_InteractionDialog.this.uiPanelPlugin.update(UNGP_InteractionDialog.this.visual);
               TooltipMakerAPI tooltip = UNGP_InteractionDialog.this.uiPanelPlugin.beginTooltip(0.0F, false);
               tooltip.addPara(Constants.root_i18n.get("hardmodeDes"), Misc.getHighlightColor(), 0.0F);
               UNGP_InteractionDialog.this.uiPanelPlugin.addTooltip(20.0F, tooltip);
               tooltip = UNGP_InteractionDialog.this.uiPanelPlugin.beginTooltip(300.0F, true);
               Iterator runnableChallenges = UNGP_InteractionDialog.this.pickedRules.iterator();

               while(runnableChallenges.hasNext()) {
                  URule rule = (URule)runnableChallenges.next();
                  TooltipMakerAPI challenge = tooltip.beginImageWithText(rule.getSpritePath(), 32.0F);
                  challenge.addPara(rule.getName(), rule.getCorrectColor(), 0.0F);
                  rule.addDesc(challenge, 0.0F);
                  tooltip.addImageWithText(3.0F);
               }

               UNGP_InteractionDialog.this.uiPanelPlugin.addTooltip(300.0F, tooltip);
               tooltip = UNGP_InteractionDialog.this.uiPanelPlugin.beginTooltip(10.0F, false);
               if(UNGP_RulePickHelper.hasUnmetReasons(UNGP_InteractionDialog.this.pickedRules, difficulty)) {
                  tooltip.setParaOrbitronLarge();
                  tooltip.addPara(Constants.root_i18n.get("rulepick_notMeet"), Misc.getNegativeHighlightColor(), 5.0F);
                  tooltip.setParaFontDefault();
                  UNGP_InteractionDialog.this.uiPanelPlugin.addTooltip(10.0F, tooltip);
               } else {
                  List runnableChallenges1 = UNGP_ChallengeManager.getRunnableChallenges(difficulty, UNGP_InteractionDialog.this.pickedRules, UNGP_InteractionDialog.this.pickedInheritData.completedChallenges);
                  if(!runnableChallenges1.isEmpty()) {
                     tooltip.addPara(Constants.root_i18n.get("rulepick_runnableChallenges"), Misc.getHighlightColor(), 10.0F);
                     UNGP_InteractionDialog.this.uiPanelPlugin.addTooltip(20.0F, tooltip);
                     tooltip = UNGP_InteractionDialog.this.uiPanelPlugin.beginTooltip(300.0F, true);
                     Iterator rule1 = runnableChallenges1.iterator();

                     while(rule1.hasNext()) {
                        UNGP_ChallengeInfo challenge1 = (UNGP_ChallengeInfo)rule1.next();
                        challenge1.createTooltip(tooltip, 5.0F, (UNGP_ChallengeProgress)null);
                     }

                     UNGP_InteractionDialog.this.uiPanelPlugin.addTooltip(300.0F, tooltip);
                  }
               }

            }
         };
         UNGP_RulePickPanelPlugin plugin = UNGP_RulePickPanelPlugin.createPlugin(difficulty, this.pickedRules, this.pickedInheritData.completedChallenges, pickTrigger, pickTrigger);
         this.dialog.showCustomVisualDialog(width, height, new UNGP_RulePickPanelDelegate(plugin, this.dialog, this.getMemoryMap()));
         break;
      case 11:
         this.inherit();
         this.addLeaveButton();
         break;
      case 12:
         this.initMenu();
         break;
      case 13:
         UNGP_InheritManager.clearSlots();
         this.dialog.dismiss();
         break;
      case 14:
         width = Global.getSettings().getScreenWidth();
         height = Global.getSettings().getScreenHeight();
         width = width < 800.0F?width:800.0F;
         height = height < 600.0F?height:600.0F;
         this.dialog.showCustomDialog(width, height, new UNGP_InteractionDialog.InheritOptionsDelegate());
      }

   }

   private void inherit() {
      TooltipMakerAPI backgroundTip = this.textPanel.beginTooltip();
      this.pickedBackground.addShortDescTooltipWithIcon(backgroundTip, 0.0F);
      this.textPanel.addTooltip();
      UNGP_BackgroundPluginAPI plugin = this.pickedBackground.getPlugin();
      float inherit_creditsFactor = plugin.getInheritCreditsFactor();
      float inherit_bpsFactor = plugin.getInheritBlueprintsFactor();
      HashMap dataSaverParams = new HashMap();
      dataSaverParams.put("inheritCreditsFactor", Float.valueOf(inherit_creditsFactor));
      dataSaverParams.put("inheritBPFactor", Float.valueOf(inherit_bpsFactor));
      dataSaverParams.put("background", this.pickedBackground);
      Iterator tooltip = this.pickedInheritData.dataSavers.iterator();

      while(tooltip.hasNext()) {
         UNGP_DataSaverAPI backgroundIntel = (UNGP_DataSaverAPI)tooltip.next();
         TooltipMakerAPI intel = this.textPanel.beginTooltip();
         backgroundIntel.startInheritDataFromSaver(intel, dataSaverParams);
         this.textPanel.addTooltip();
      }

      TooltipMakerAPI tooltip1 = this.textPanel.beginTooltip();
      UNGP_BackgroundManager.setPlayerBackground(this.pickedBackground);
      plugin.afterConfirm(this.pickedInheritData);
      plugin.addAfterConfirmTooltip(tooltip1, this.pickedInheritData);
      UNGP_BackgroundIntel backgroundIntel1 = new UNGP_BackgroundIntel(Global.getSector().getPlayerFleet().getStarSystem());
      Global.getSector().getIntelManager().addIntel(backgroundIntel1);
      this.textPanel.addTooltip();
      this.textPanel.setFontInsignia();
      if(this.isSpecialistMode) {
         this.textPanel.addPara(Constants.root_i18n.get("hardModeYes"), Misc.getNegativeHighlightColor());
      }

      this.inGameData.setCurCycle(this.pickedInheritData.cycle);
      this.inGameData.setInherited(true);
      this.inGameData.setHardMode(this.isSpecialistMode);
      this.inGameData.setCompletedChallenges(this.pickedInheritData.completedChallenges);
      if(this.isSpecialistMode) {
         this.inGameData.setDifficulty((Difficulty)this.settingEntry_difficulty.getValue());
         this.inGameData.saveActivatedRules(this.pickedRules);
         UNGP_Feedback.setFeedBackList(this.pickedRules);
         final UNGP_SpecialistIntel intel1 = new UNGP_SpecialistIntel();
         Global.getSector().getIntelManager().addIntel(intel1, false, this.textPanel);
         UNGP_ChallengeIntel challengeIntel = UNGP_ChallengeManager.confirmChallenges(this.inGameData);
         if(challengeIntel != null) {
            Global.getSector().getIntelManager().addIntelToTextPanel(challengeIntel, this.textPanel);
         }

         UNGP_RulesManager.updateRulesCache();
         Global.getSector().addTransientScript(new EveryFrameScript() {

            private float elapsed = 0.0F;
            private boolean isDone = false;

            public boolean isDone() {
               return this.isDone;
            }
            public boolean runWhilePaused() {
               return false;
            }
            public void advance(float amount) {
               if(!this.isDone()) {
                  this.elapsed += amount;
                  if(this.elapsed > 0.1F) {
                     this.isDone = true;
                     Global.getSector().getCampaignUI().showCoreUITab(CoreUITabId.INTEL, intel1);
                     Global.getSector().removeTransientScript(this);
                  }

               }
            }
         });
      }

   }

   private void record(UNGP_InteractionDialog.OptionID option) {
      this.inGameData.setRecorded(true);
      this.saveRecordByChosenOption(this.pregenInheritData, option);
      Global.getSoundPlayer().playUISound("ui_rep_raise", 1.0F, 1.0F);
      this.textPanel.addPara(Constants.root_i18n.get("recordSuccess"));
   }

   public void optionMousedOver(String optionText, Object optionData) {
   }

   private void setSpecialistModeToolTip() {
      if(this.options.hasOption(UNGP_InteractionDialog.OptionID.INHERIT) && !this.pickedRules.isEmpty()) {
         String[] ruleNames = new String[this.pickedRules.size()];
         Color[] ruleColors = new Color[this.pickedRules.size()];
         StringBuilder result = new StringBuilder(Constants.root_i18n.get("hardmodeDes"));

         for(int i = 0; i < this.pickedRules.size(); ++i) {
            URule rule = (URule)this.pickedRules.get(i);
            result.append("\n  ");
            result.append(rule.getName());
            ruleNames[i] = rule.getName();
            ruleColors[i] = rule.getCorrectColor();
         }

         this.options.setTooltip(UNGP_InteractionDialog.OptionID.INHERIT, result.toString());
         this.options.setTooltipHighlights(UNGP_InteractionDialog.OptionID.INHERIT, ruleNames);
         this.options.setTooltipHighlightColors(UNGP_InteractionDialog.OptionID.INHERIT, ruleColors);
      }

   }

   public void advance(float amount) {
      if(this.isSpecialistMode && this.options.hasOption(UNGP_InteractionDialog.OptionID.INHERIT)) {
         this.options.setEnabled(UNGP_InteractionDialog.OptionID.INHERIT, UNGP_SpecialistSettings.rulesMeetCondition(this.pickedRules, (Difficulty)this.settingEntry_difficulty.getValue()));
      }

   }

   private void updateOptionsFromSettings() {
      if(this.options.hasOption(UNGP_InteractionDialog.OptionID.INHERIT)) {
         float inherit_creditsFactor = 0.0F;
         float inherit_bpsFactor = 0.0F;
         if(this.pickedBackground != null && this.pickedBackground.getPlugin() != null) {
            inherit_creditsFactor = this.pickedBackground.getPlugin().getInheritCreditsFactor();
            inherit_bpsFactor = this.pickedBackground.getPlugin().getInheritBlueprintsFactor();
         }

         final int bpInheritGeneratedByDataSaver = 0;
         final int creditsInheritGeneratedByDataSaver = 0;
         Iterator bpInherited = this.pickedInheritData.dataSavers.iterator();

         while(bpInherited.hasNext()) {
            UNGP_DataSaverAPI creditsInherited = (UNGP_DataSaverAPI)bpInherited.next();
            if(creditsInherited instanceof UNGP_BlueprintsDataSaver) {
               UNGP_BlueprintsDataSaver isSpecialistMode = (UNGP_BlueprintsDataSaver)creditsInherited;
               bpInheritGeneratedByDataSaver = (int)((float)isSpecialistMode.bpAmount * inherit_bpsFactor);
            }

            if(creditsInherited instanceof UNGP_CreditsDataSaver) {
               UNGP_CreditsDataSaver isSpecialistMode1 = (UNGP_CreditsDataSaver)creditsInherited;
               creditsInheritGeneratedByDataSaver = (int)((float)isSpecialistMode1.getCredits() * inherit_creditsFactor);
            }
         }

         final boolean isSpecialistMode2 = this.isSpecialistMode;
         final Difficulty difficulty = (Difficulty)this.settingEntry_difficulty.getValue();
         TooltipMakerAPI tooltip = this.textPanel.beginTooltip();
         TooltipMakerAPI section = tooltip.beginImageWithText("graphics/icons/reports/storage24.png", 24.0F);
         section.addPara(Constants.root_i18n.get("inheritOptions"), Misc.getBasePlayerColor(), 0.0F);
         tooltip.addImageWithText(5.0F);
         tooltip.setBulletedListMode("       ");
         if(this.pickedBackground != null) {
            tooltip.addSpacer(10.0F);
            tooltip.setBulletedListMode((String)null);
            this.pickedBackground.addDescriptionTooltip(tooltip, this.pickedInheritData, false);
         }

         tooltip.setBulletedListMode("       ");
         if(difficulty != null) {
            TooltipMakerAPI hardSection = tooltip.beginImageWithText(difficulty.spritePath, 64.0F);
            hardSection.addPara(Constants.root_i18n.get("hardmodeLevel"), 0.0F, difficulty.color, new String[]{difficulty.name});
            tooltip.addImageWithText(5.0F);
         }

         tooltip.setBulletedListMode((String)null);
         this.textPanel.addTooltip();
         this.options.addOptionConfirmation(UNGP_InteractionDialog.OptionID.INHERIT, new UNGP_InteractionDialog.CustomStoryDialogDelegate() {
            public String getTitle() {
               return Constants.root_i18n.get("startInherit");
            }
            public void createDescription(TooltipMakerAPI info) {
               float pad = 10.0F;
               String credits = Misc.getDGSCredits((float)creditsInheritGeneratedByDataSaver);
               Color hl = Misc.getHighlightColor();
               Color negative = Misc.getNegativeHighlightColor();
               UNGP_InteractionDialog.this.pickedBackground.addDescriptionTooltip(info, UNGP_InteractionDialog.this.pickedInheritData, false);
               info.addSectionHeading(Constants.root_i18n.get("inheritConfirmHeading"), Alignment.LMID, 5.0F);
               info.addPara(Constants.root_i18n.get("inheritConfirmInfo0"), 5.0F, hl, new String[]{credits, bpInheritGeneratedByDataSaver});
               if(difficulty != null && isSpecialistMode2) {
                  info.addSpacer(pad);
                  info.addSectionHeading(Constants.root_i18n.format("rulepick_level", new Object[]{difficulty.name}), hl, Misc.scaleAlpha(negative, 0.2F), Alignment.MID, pad * 0.5F);
                  float width = info.getPrev().getPosition().getWidth();
                  info.addPara(Constants.root_i18n.get("inheritConfirmInfo1"), negative, 5.0F).setAlignment(Alignment.MID);
                  info.addSpacer(pad);
                  int ruleSize = UNGP_InteractionDialog.this.pickedRules.size();
                  int itemsPerRow = (int)(width / 64.0F);
                  int page = Math.max(0, ruleSize - 1) / itemsPerRow;

                  for(int i = 0; i <= page; ++i) {
                     ArrayList ruleSprites = new ArrayList();

                     for(int array = i * itemsPerRow; array < (i + 1) * itemsPerRow; ++array) {
                        if(array < ruleSize) {
                           ruleSprites.add(((URule)UNGP_InteractionDialog.this.pickedRules.get(array)).getSpritePath());
                        }
                     }

                     if(!ruleSprites.isEmpty()) {
                        String[] var13 = (String[])ruleSprites.toArray(new String[0]);
                        info.addImages(width, 64.0F, 0.0F, 4.0F, var13);
                     }
                  }
               }

            }
         });
      }

   }

   public void backFromEngagement(EngagementResultAPI battleResult) {
   }

   private void addLeaveButton() {
      this.options.addOption(Constants.root_i18n.get("leave"), UNGP_InteractionDialog.OptionID.LEAVE);
   }

   private void addBackButton(UNGP_InteractionDialog.OptionID warpOption) {
      this.options.addOption(Constants.root_i18n.get("back"), warpOption);
   }

   public Object getContext() {
      return null;
   }

   public Map getMemoryMap() {
      return null;
   }

   public void resetSettings() {
      this.settingEntry_difficulty.reset();
      this.pickedBackground = UNGP_BackgroundManager.getDefaultBackground();
      this.backgroundCheckBoxGroup = null;
      this.isSpecialistMode = false;
      this.pickedRules.clear();
   }

   private static enum OptionID {

      CHECK_INHERIT_SLOTS,
      CHECK_RECORD_SLOTS,
      HELP,
      CHOOSE_INHERIT_SLOT_0,
      CHOOSE_INHERIT_SLOT_1,
      CHOOSE_INHERIT_SLOT_2,
      PICK_RULES_NEW,
      INHERIT,
      INHERIT_SETTINGS,
      CHOOSE_RECORD_SLOT_0,
      CHOOSE_RECORD_SLOT_1,
      CHOOSE_RECORD_SLOT_2,
      BACK_TO_MENU,
      LEAVE;
      // $FF: synthetic field
      private static final UNGP_InteractionDialog.OptionID[] $VALUES = $values();


      // $FF: synthetic method
      private static UNGP_InteractionDialog.OptionID[] $values() {
         return new UNGP_InteractionDialog.OptionID[]{CHECK_INHERIT_SLOTS, CHECK_RECORD_SLOTS, HELP, CHOOSE_INHERIT_SLOT_0, CHOOSE_INHERIT_SLOT_1, CHOOSE_INHERIT_SLOT_2, PICK_RULES_NEW, INHERIT, INHERIT_SETTINGS, CHOOSE_RECORD_SLOT_0, CHOOSE_RECORD_SLOT_1, CHOOSE_RECORD_SLOT_2, BACK_TO_MENU, LEAVE};
      }

   }

   private abstract static class InheritSettingEntry implements UNGP_DataSaverSettingEntryAPI {

      private SettingEntry valueEntry;
      protected String entryTitle;
      protected Color entryTitleColor;
      protected Object[] optionValues;
      protected String[] optionNames;
      protected Color[] optionBaseColor;
      protected Color[] optionDarkColor;
      protected Color[] optionBrightColor;
      protected CheckBoxGroup checkBoxGroup;
      protected HorizontalButtonGroup optionGroup;


      public InheritSettingEntry(Object defaultValue, int optionSize) {
         this.valueEntry = new SettingEntry(defaultValue);
         this.optionValues = new Object[optionSize];
         this.optionNames = new String[optionSize];
         this.optionBaseColor = new Color[optionSize];
         this.optionDarkColor = new Color[optionSize];
         this.optionBrightColor = new Color[optionSize];
         this.initParams(optionSize);
      }

      public abstract void initParams(int var1);

      public void addEntry(TooltipMakerAPI tooltip, float width) {
         this.checkBoxGroup = new CheckBoxGroup();
         this.optionGroup = new HorizontalButtonGroup();
         tooltip.addPara(this.entryTitle, this.entryTitleColor, 0.0F);
         tooltip.addSpacer(5.0F);
         int optionSize = this.optionValues.length;
         float buttonWidth = width / (float)optionSize - 10.0F;

         for(int i = 0; i < optionSize; ++i) {
            Object value = this.optionValues[i];
            ButtonAPI checkBox = tooltip.addAreaCheckbox(this.optionNames[i], (Object)null, this.optionBaseColor[i], this.optionDarkColor[i], this.optionBrightColor[i], buttonWidth, 30.0F, 0.0F);
            this.addTipToOption(tooltip, value);
            this.optionGroup.addButton(checkBox);
            this.checkBoxGroup.addCheckBox(checkBox, value);
         }

         this.optionGroup.updateTooltip(tooltip, 5.0F);
         this.checkBoxGroup.tryCheckValue(this.valueEntry.get());
      }

      protected void addTipToOption(TooltipMakerAPI tooltip, Object option) {
      }

      public void reset() {
         this.cancelConfirm();
         this.valueEntry.reset();
      }

      public void advance(float amount) {
         if(this.checkBoxGroup != null) {
            this.checkBoxGroup.updateCheck();
         }

      }

      public Object confirmValue() {
         Object value = this.checkBoxGroup.getCheckedValue();
         this.valueEntry.set(value);
         return value;
      }

      public void cancelConfirm() {
         this.checkBoxGroup = null;
         this.optionGroup = null;
      }

      public Object getValue() {
         return this.valueEntry.get();
      }
   }

   private class RecordDialogDelegate extends BaseCustomDialogDelegate {

      private ButtonAPI btn_recordCargo;
      private ButtonAPI btn_recordShip;
      private ButtonAPI btn_recordColony;
      private ButtonAPI btn_recordSlotBPs;
      private UNGP_InteractionDialog.OptionID selectedOption;


      public RecordDialogDelegate(UNGP_InteractionDialog.OptionID selectedOption) {
         this.selectedOption = selectedOption;
      }

      public void createCustomDialog(CustomPanelAPI panel, CustomDialogCallback callback) {
         float width = panel.getPosition().getWidth();
         float height = panel.getPosition().getHeight();
         float pad = 5.0F;
         TooltipMakerAPI info = panel.createUIElement(width, height, true);
         panel.addUIElement(info);
         info.setParaOrbitronLarge();
         info.addPara(Constants.root_i18n.get("recordConfirmInfo"), Misc.getNegativeHighlightColor(), 0.0F);
         info.addSpacer(30.0F);
         info.setAreaCheckboxFont("graphics/fonts/orbitron24aa.fnt");
         info.addPara(Constants.root_i18n.get("recordExtraCreditsTitle"), Misc.getHighlightColor(), 0.0F);
         info.addSpacer(pad);
         float buttonWidth = width / 3.0F - 10.0F;
         float buttonHeight = 30.0F;
         HorizontalButtonGroup extraCreditsGroup = new HorizontalButtonGroup();
         this.btn_recordCargo = info.addAreaCheckbox(Constants.root_i18n.get("recordExtraCredits_cargo"), (Object)null, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), buttonWidth, buttonHeight, 0.0F);
         this.btn_recordShip = info.addAreaCheckbox(Constants.root_i18n.get("recordExtraCredits_ship"), (Object)null, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), buttonWidth, buttonHeight, 0.0F);
         this.btn_recordColony = info.addAreaCheckbox(Constants.root_i18n.get("recordExtraCredits_colony"), (Object)null, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), buttonWidth, buttonHeight, 0.0F);
         extraCreditsGroup.addButton(this.btn_recordCargo);
         extraCreditsGroup.addButton(this.btn_recordShip);
         extraCreditsGroup.addButton(this.btn_recordColony);
         extraCreditsGroup.updateTooltip(info, 10.0F);
         info.addSpacer(pad);
         info.addPara(Constants.root_i18n.get("recordExtraBPsTitle"), Misc.getHighlightColor(), 0.0F);
         info.addSpacer(pad);
         this.btn_recordSlotBPs = info.addAreaCheckbox(Constants.root_i18n.get("recordExtraBPs_selectedSlot"), (Object)null, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), buttonWidth, buttonHeight, 0.0F);
      }

      public boolean hasCancelButton() {
         return true;
      }

      public String getConfirmText() {
         return null;
      }

      public String getCancelText() {
         return null;
      }

      public void customDialogConfirm() {
         float extraCredits = 0.0F;
         boolean recordCargo = this.btn_recordCargo.isChecked();
         boolean recordShip = this.btn_recordShip.isChecked();
         boolean recordIndustry = this.btn_recordColony.isChecked();
         boolean recordSelectedSlotBPs = this.btn_recordSlotBPs.isChecked();
         CargoAPI convertCargo = Global.getFactory().createCargo(true);
         Iterator playerFleet = Global.getSector().getEconomy().getMarketsCopy().iterator();

         Iterator storageCargo1;
         while(playerFleet.hasNext()) {
            MarketAPI playerCargo = (MarketAPI)playerFleet.next();
            if(Misc.playerHasStorageAccess(playerCargo)) {
               CargoAPI storageCargo = Misc.getStorageCargo(playerCargo);
               if(storageCargo != null) {
                  if(recordCargo) {
                     convertCargo.addAll(storageCargo);
                  }

                  if(recordShip) {
                     FleetDataAPI dataSaver = storageCargo.getMothballedShips();
                     FleetMemberAPI bpSaverFromSlot;
                     if(dataSaver != null) {
                        for(Iterator dataFromSlot = dataSaver.getMembersListCopy().iterator(); dataFromSlot.hasNext(); extraCredits += bpSaverFromSlot.getBaseValue()) {
                           bpSaverFromSlot = (FleetMemberAPI)dataFromSlot.next();
                        }
                     }
                  }
               }
            }

            Industry dataSaver1;
            if(recordIndustry && playerCargo.isPlayerOwned()) {
               for(storageCargo1 = playerCargo.getIndustries().iterator(); storageCargo1.hasNext(); extraCredits += dataSaver1.getBuildCost()) {
                  dataSaver1 = (Industry)storageCargo1.next();
               }
            }
         }

         CampaignFleetAPI playerFleet1 = Global.getSector().getPlayerFleet();
         CargoAPI playerCargo1 = playerFleet1.getCargo();
         if(recordCargo) {
            convertCargo.addAll(playerCargo1);

            CargoStackAPI dataSaver2;
            for(storageCargo1 = convertCargo.getStacksCopy().iterator(); storageCargo1.hasNext(); extraCredits += (float)dataSaver2.getBaseValuePerUnit() * dataSaver2.getSize()) {
               dataSaver2 = (CargoStackAPI)storageCargo1.next();
            }
         }

         FleetMemberAPI dataSaver3;
         if(recordShip && playerFleet1.getFleetData() != null) {
            for(storageCargo1 = playerFleet1.getFleetData().getMembersListCopy().iterator(); storageCargo1.hasNext(); extraCredits += dataSaver3.getBaseValue()) {
               dataSaver3 = (FleetMemberAPI)storageCargo1.next();
            }
         }

         UNGP_InteractionDialog.this.textPanel.addPara(Constants.root_i18n.get("recordExtraCredits_success"), Misc.getHighlightColor(), new String[]{Misc.getDGSCredits(extraCredits)});
         storageCargo1 = UNGP_InteractionDialog.this.pregenInheritData.dataSavers.iterator();

         while(storageCargo1.hasNext()) {
            UNGP_DataSaverAPI dataSaver4 = (UNGP_DataSaverAPI)storageCargo1.next();
            if(dataSaver4 instanceof UNGP_CreditsDataSaver) {
               ((UNGP_CreditsDataSaver)dataSaver4).addCredits((int)extraCredits);
            }

            if(recordSelectedSlotBPs && dataSaver4 instanceof UNGP_BlueprintsDataSaver) {
               UNGP_InheritData dataFromSlot1 = UNGP_InheritManager.getDataFromSlot(UNGP_InteractionDialog.this.getSlotIdByOption(this.selectedOption));
               if(dataFromSlot1 != null) {
                  UNGP_BlueprintsDataSaver bpSaverFromSlot1 = (UNGP_BlueprintsDataSaver)dataFromSlot1.getFirstSaverOfClass(UNGP_BlueprintsDataSaver.class);
                  if(bpSaverFromSlot1 != null) {
                     Object extraBPAmount = ((UNGP_BlueprintsDataSaver)dataSaver4).add(bpSaverFromSlot1);
                     UNGP_InteractionDialog.this.textPanel.addPara(Constants.root_i18n.get("recordExtraBPs_success"), Misc.getHighlightColor(), new String[]{(String)extraBPAmount});
                  }
               }
            }
         }

         UNGP_InteractionDialog.this.record(this.selectedOption);
      }

      public void customDialogCancel() {
         UNGP_InteractionDialog.this.optionSelected((String)null, UNGP_InteractionDialog.OptionID.CHECK_RECORD_SLOTS);
      }

      public CustomUIPanelPlugin getCustomPanelPlugin() {
         return null;
      }
   }

   private class InheritOptionsDelegate extends BaseCustomDialogDelegate {

      public void createCustomDialog(CustomPanelAPI panel, CustomDialogCallback callback) {
         float width = panel.getPosition().getWidth();
         float height = panel.getPosition().getHeight();
         float backgroundHeight = height * 0.8F;
         float extraOptionsHeight = height - backgroundHeight;
         float backgroundTitleHeight = 30.0F;
         UNGP_Background previousBackground = null;
         if(UNGP_InteractionDialog.this.pickedBackground != null) {
            previousBackground = UNGP_InteractionDialog.this.pickedBackground;
         }

         UNGP_InteractionDialog.this.backgroundCheckBoxGroup = new CheckBoxGroup();
         TooltipMakerAPI backgroundTitleTip = panel.createUIElement(width, backgroundTitleHeight, false);
         backgroundTitleTip.setParaOrbitronLarge();
         backgroundTitleTip.addPara(Constants.root_i18n.get("inherit_choose_background"), Misc.getBasePlayerColor(), 0.0F);
         panel.addUIElement(backgroundTitleTip).inTL(0.0F, 0.0F);
         TooltipMakerAPI backgroundTip = panel.createUIElement(width, backgroundHeight - backgroundTitleHeight, true);
         backgroundTip.setParaOrbitronLarge();
         float backgroundBoxWidth = width - 10.0F;
         float spacerHeight = 5.0F;
         List allBackgrounds = UNGP_BackgroundManager.getSortedBackgroundsCopy();
         Iterator tooltip = allBackgrounds.iterator();

         while(tooltip.hasNext()) {
            UNGP_Background background = (UNGP_Background)tooltip.next();
            ButtonAPI checkbox = backgroundTip.addAreaCheckbox("", (Object)null, Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 0.0F, 0.0F, 0.0F, true);
            backgroundTip.addTooltipToPrevious(new BackgroundTooltipCreator(background, UNGP_InteractionDialog.this.pickedInheritData, backgroundBoxWidth - 20.0F), TooltipLocation.BELOW);
            background.addShortDescTooltipWithIcon(backgroundTip, spacerHeight);
            PositionAPI imageWithTextPosition = backgroundTip.getPrev().getPosition();
            float imageWithTextHeight = imageWithTextPosition.getHeight();
            float imageWithTextWidth = imageWithTextPosition.getWidth();
            float imageWithTextXOffset = 7.0F;
            backgroundTip.addSpacer(spacerHeight);
            imageWithTextPosition.setXAlignOffset(imageWithTextXOffset);
            imageWithTextPosition.setSize(imageWithTextWidth - 15.0F, imageWithTextHeight);
            checkbox.getPosition().setSize(backgroundBoxWidth, imageWithTextHeight + spacerHeight * 2.0F);
            imageWithTextPosition.setYAlignOffset(imageWithTextHeight + spacerHeight);
            backgroundTip.addSpacer(0.0F).getPosition().setXAlignOffset(-imageWithTextXOffset);
            UNGP_InteractionDialog.this.backgroundCheckBoxGroup.addCheckBox(checkbox, background);
         }

         backgroundTip.addSpacer(0.0F);
         panel.addUIElement(backgroundTip).inTL(0.0F, backgroundTitleHeight);
         TooltipMakerAPI tooltip1 = panel.createUIElement(width, extraOptionsHeight, false);
         tooltip1.setParaOrbitronLarge();
         tooltip1.setAreaCheckboxFont("graphics/fonts/orbitron24aa.fnt");
         tooltip1.addSpacer(10.0F);
         if(previousBackground != null) {
            UNGP_InteractionDialog.this.backgroundCheckBoxGroup.tryCheckValue(previousBackground);
         } else {
            UNGP_InteractionDialog.this.backgroundCheckBoxGroup.tryCheckValue(UNGP_BackgroundManager.getDefaultBackground());
         }

         UNGP_InteractionDialog.this.settingEntry_difficulty.addEntry(tooltip1, width);
         panel.addUIElement(tooltip1).inTL(0.0F, backgroundHeight);
      }

      public boolean hasCancelButton() {
         return true;
      }

      public void customDialogConfirm() {
         if(UNGP_InteractionDialog.this.backgroundCheckBoxGroup != null) {
            UNGP_InteractionDialog.this.pickedBackground = (UNGP_Background)UNGP_InteractionDialog.this.backgroundCheckBoxGroup.getCheckedValue();
         }

         Difficulty difficulty = (Difficulty)UNGP_InteractionDialog.this.settingEntry_difficulty.confirmValue();
         UNGP_InteractionDialog.this.isSpecialistMode = difficulty != null;
         UNGP_InteractionDialog.this.optionSelected((String)null, UNGP_InteractionDialog.this.choseInheritSlotOptionID);
      }

      public void customDialogCancel() {
         UNGP_InteractionDialog.this.settingEntry_difficulty.cancelConfirm();
         UNGP_InteractionDialog.this.optionSelected((String)null, UNGP_InteractionDialog.this.choseInheritSlotOptionID);
      }

      public CustomUIPanelPlugin getCustomPanelPlugin() {
         return new CustomUIPanelPlugin() {
            public void positionChanged(PositionAPI position) {
            }
            public void renderBelow(float alphaMult) {
            }
            public void render(float alphaMult) {
            }
            public void advance(float amount) {
               if(UNGP_InteractionDialog.this.backgroundCheckBoxGroup != null) {
                  UNGP_InteractionDialog.this.backgroundCheckBoxGroup.updateCheck();
               }

               UNGP_InteractionDialog.this.settingEntry_difficulty.advance(amount);
            }
            public void processInput(List events) {
            }
            public void buttonPressed(Object buttonId) {
            }
         };
      }
   }

   private class CustomStoryDialogDelegate extends BaseStoryPointActionDelegate {

      public boolean withDescription() {
         return true;
      }

      public boolean withSPInfo() {
         return false;
      }

      public String getLogText() {
         return null;
      }

      public float getBonusXPFraction() {
         return 0.0F;
      }

      public TextPanelAPI getTextPanel() {
         return UNGP_InteractionDialog.this.dialog == null?null:UNGP_InteractionDialog.this.textPanel;
      }

      public String getConfirmSoundId() {
         return "ui_acquired_blueprint";
      }

      public int getRequiredStoryPoints() {
         return 0;
      }
   }

   private static class DifficultyTooltipCreator implements TooltipCreator {

      private Difficulty difficulty;


      public DifficultyTooltipCreator(Difficulty difficulty) {
         this.difficulty = difficulty;
      }

      public boolean isTooltipExpandable(Object tooltipParam) {
         return false;
      }

      public float getTooltipWidth(Object tooltipParam) {
         return 200.0F;
      }

      public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
         if(this.difficulty == null) {
            tooltip.addPara(Constants.root_i18n.get("difficulty_desc_null"), 0.0F);
         } else {
            Color hl = Misc.getHighlightColor();
            tooltip.addPara(Constants.root_i18n.get("difficulty_desc_base"), 0.0F, hl, new String[]{this.difficulty.minRules, this.difficulty.maxRules});
            tooltip.addPara(Constants.root_i18n.get("difficulty_desc_value"), 0.0F, hl, new String[]{(int)(this.difficulty.extraValueMultiplier * 100.0F)});
            if(UNGP_ChallengeManager.isDifficultyEnough(this.difficulty)) {
               tooltip.addPara(Constants.root_i18n.get("difficulty_desc_max"), hl, 5.0F);
            }
         }

      }
   }
}
